# og[XLǗNX
# Author:: fukuyama
# Date:: 2007/10/08
# Copyright:: Copyright (C) 2007 rgss-lib

module Game_Battler_Module
  module_function
  
  # XL̃Xe[gĂ邩HiXLĂ邩Hj
  # XLĂꍇ́Atrue
  def skill_state?(target,skill)
    skill.plus_state_set.each do |state_id|
      unless target.state?(state_id)
        return false
      end
    end
    return true
  end
  
  # ACẽXe[gĂ邩HiACeĂ邩Hj
  # ACeĂꍇ́Atrue
  def item_state?(target,item)
    item.plus_state_set.each do |state_id|
      unless target.state?(state_id)
        return false
      end
    end
    return true
  end
  
  # U_[W
  def calculate_attack_damage(target,attacker)
    # {_[WvZ
    atk = [attacker.atk - target.pdef / 2, 0].max
    damage = atk * (20 + attacker.str) / 20
    # _[WȌꍇ́AŒ_[WPɂ
    if damage == 0
      damage = 1
    end
    # C
    damage *= target.elements_correct(attacker.element_set)
    damage /= 100
    return damage
  end
  
  # XL̃_[WvZ
  def calculate_skill_damage(target,user,skill)
    # З͂vZ
    power = skill.power + user.atk * skill.atk_f / 100
    if power > 0
      power -= target.pdef * skill.pdef_f / 200
      power -= target.mdef * skill.mdef_f / 200
      power = [power, 0].max
    end
    # {vZ
    rate = 20
    rate += (user.str * skill.str_f / 100)
    rate += (user.dex * skill.dex_f / 100)
    rate += (user.agi * skill.agi_f / 100)
    rate += (user.int * skill.int_f / 100)
    # {_[WvZ
    damage = power * rate / 20
    # C
    damage *= target.elements_correct(skill.element_set)
    damage /= 100
    # _[W̏̕ꍇ
    if damage > 0
      # hC
      if target.guarding?
        damage /= 2
      end
    end
    return damage
  end
  
  # ACẻ񕜗ʂvZ
  def calculate_item_recover_hp(target,user,item)
    # 񕜗ʂvZ
    recover_hp = target.maxhp * item.recover_hp_rate / 100 + item.recover_hp
    if recover_hp < 0
      recover_hp += target.pdef * item.pdef_f / 20
      recover_hp += target.mdef * item.mdef_f / 20
      recover_hp = [recover_hp, 0].min
    end
    # C
    recover_hp *= target.elements_correct(item.element_set)
    recover_hp /= 100
    return recover_hp
  end
  def calculate_item_damage(target,user,item)
    return calculate_item_recover_hp(target,user,item)
  end
  
  # ACẻ񕜗ʂvZ
  def calculate_item_recover_sp(target,user,item)
    recover_sp = target.maxsp * item.recover_sp_rate / 100 + item.recover_sp
    recover_sp *= target.elements_correct(item.element_set)
    recover_sp /= 100
    return recover_sp
  end
  
  # Zo
  def calculate_attack_hit(target,attacker)
    # łȂ
    if target.cant_evade?
      return 100.0
    end
    # 
    return attacker.hit * (100 - (8 * target.agi / attacker.dex + target.eva)) / 100.0
  end
end
