#==============================================================================
#  AutoCure
#------------------------------------------------------------------------------
# 񕜂`h
# Copyright (C) 2005 fukuyama
#==============================================================================

module Battle_AI
  
  class AutoCure < Battle_AI_Base
    def initialize(name,hp_rate)
      super(name)
      # go[gigo̊A̒lɂȂAN^[񕜁j
      @hp_rate = hp_rate
    end
    def create_damage_battlers
      battlers = []
      partners.each do |partner|
        if partner.hp < partner.maxhp
          battlers.push partner
        end
      end
      return battlers
    end
    def get_hp_recover_skills
      result = []
      battler.skills.each do |skill_id|
        next if not battler.skill_can_use?(skill_id)
        skill = $data_skills[skill_id]
        if skill.power < 0 && skill.scope == 3 # Ƃ肠P
          result.push skill
        end
      end
      return result
    end
    def make_action
      # Ƃ肠UɂĂ
      setup_normal_attack(targets[0])
      
      cure_target = nil
      damage_battlers = create_damage_battlers
      hp_battlers = damage_battlers.sort do |a,b|
        a.hp <=> b.hp
      end
      hprate_battlers = damage_battlers.sort do |a,b|
        a_rate = a.hp.to_f / a.maxhp.to_f * 100.0
        b_rate = b.hp.to_f / b.maxhp.to_f * 100.0
        a_rate <=> b_rate
      end
      if not hprate_battlers.empty?
        target = hprate_battlers[0]
        rate = target.hp.to_f / target.maxhp.to_f * 100.0
        if rate < @hp_rate
          damage = target.maxhp - target.hp
          skills = get_hp_recover_skills.sort {|a,b| a.power <=> b.power}
          if not skills.empty?
            use_skill = skills[0]
            skills.each do |skill|
              if damage < skill.power
                # _[W񕜗ʂ̂΁AI
                use_skill = skill
              end
            end
            # XLgp
            setup_skill(use_skill,target)
          end
        end
      end
    end
  end
  
end
