#==============================================================================
#  DijkstraAlgorithm
#------------------------------------------------------------------------------
# _CNXgASY̎
#==============================================================================

class DijkstraAlgorithm
  # ̍ől
  MAX_DISTANCE = 32767
  
  # 
  def initialize(nodes)
    @nodes = nodes.dup
    @size = @nodes.size
    @matrix = Array.new(@size)
    for i in 0 ... @size
      @matrix[i] = Array.new(@size,MAX_DISTANCE)
    end
    @distance = Array.new(@size,MAX_DISTANCE)
  end
  
  # אڍs̍쐬\bh
  # ubNŃm[hQɋZo
  def setupMatrix()
    @nodes.each_index do |i|
      @nodes.each_index do |j|
        @matrix[i][j] = yield(@nodes[i],@nodes[j])
      end
    end
  end
  
  # oHT
  def search(source_node, target_node)
    source = @nodes.index source_node
    target = @nodes.index target_node
    if source.nil? or target.nil?
      return []
    end
    visited = Array.new(@size,false)
    prev = Array.new(@size,-1)
    @distance = Array.new(@size,MAX_DISTANCE)
    @distance[source] = 0
    n = source
    begin
      i = n
      visited[i] = true
      min = MAX_DISTANCE
      for j in 0 ... @size
        next if visited[j]
        if (@matrix[i][j] < MAX_DISTANCE) and	(@distance[i] + @matrix[i][j] < @distance[j])
          @distance[j] = @distance[i] + @matrix[i][j]
          prev[j] = i
        end
        if @distance[j] < min
          min = @distance[j]
          n = j
        end
      end
    end while min < MAX_DISTANCE
    if prev[target] < 0
      # [gȂ
      return []
    end
    # [g쐬
    routes = [@nodes[target]]
    route = prev[target]
    while route >= 0
      routes.unshift @nodes[route]
      route = prev[route]
    end
    return routes
  end
end
