#==============================================================================
#  Script_Event
#------------------------------------------------------------------------------
# XNvgCxgs邽߂̂`oh
# Copyright (C) 2005 fukuyama
#==============================================================================

class Script_Event
  attr_reader :event_commands
  def initialize
    @event_commands = []
    @indent = 0
  end

  #----------------------------------------------------------------------------
  # bZ[W\
  #----------------------------------------------------------------------------
  def message(msg)
    case msg
    when String
      @event_commands.push RPG::EventCommand.new(101,@indent,[msg])
    when Array
      msg.each do |line|
        @event_commands.push RPG::EventCommand.new(101,@indent,[line])
      end
    end
  end

  #----------------------------------------------------------------------------
  # IJn
  #----------------------------------------------------------------------------
  def branch_start(list,cancel_type = 0)
    @event_commands.push RPG::EventCommand.new(102,@indent,[list,cancel_type])
    @indent += 1
  end

  #----------------------------------------------------------------------------
  # IACe
  #----------------------------------------------------------------------------
  def branch_item(select_index,script_event=nil)
    @event_commands.push RPG::EventCommand.new(402,@indent - 1,[select_index])
    if not script_event.nil?
      add script_event
    end
  end

  #----------------------------------------------------------------------------
  # II
  #----------------------------------------------------------------------------
  def branch_end
    @indent -= 1
    @event_commands.push RPG::EventCommand.new(404,@indent)
  end

  def script_condition(*args)
    @event_commands.push RPG::EventCommand.new(111,@indent,[12,*args])
    @indent += 1
  end

  def condition_end
    @indent -= 1
    @event_commands.push RPG::EventCommand.new(404,@indent)
  end

  def loop_start
    @event_commands.push RPG::EventCommand.new(112,@indent,nil)
    @indent += 1
  end

  def loop_break
    @event_commands.push RPG::EventCommand.new(113,@indent,nil)
  end

  def loop_end
    @indent -= 1
    @event_commands.push RPG::EventCommand.new(413,@indent,nil)
  end

  def label(name)
    @event_commands.push RPG::EventCommand.new(118,@indent,[name])
  end

  def label_jump(name)
    @event_commands.push RPG::EventCommand.new(119,@indent,[name])
  end

  #----------------------------------------------------------------------------
  # ld̉t
  #----------------------------------------------------------------------------
  def me_start(rpg_audiofile)
    @event_commands.push RPG::EventCommand.new(249,@indent,[rpg_audiofile])
  end

  #----------------------------------------------------------------------------
  # rd̉t
  #----------------------------------------------------------------------------
  def se_start(rpg_audiofile)
    return if rpg_audiofile.nil?
    @event_commands.push RPG::EventCommand.new(250,@indent,[rpg_audiofile])
  end

  #----------------------------------------------------------------------------
  # rd̉t
  #----------------------------------------------------------------------------
  def se_stop()
    @event_commands.push RPG::EventCommand.new(251,@indent,[])
  end

  #----------------------------------------------------------------------------
  # EFCg
  #----------------------------------------------------------------------------
  def wait(count)
    @event_commands.push RPG::EventCommand.new(106,@indent,[count])
  end

  #----------------------------------------------------------------------------
  # uN
  #----------------------------------------------------------------------------
  def brank
    @event_commands.push RPG::EventCommand.new(0,@indent)
  end

  #----------------------------------------------------------------------------
  # CxgI
  #----------------------------------------------------------------------------
  def event_break
    @event_commands.push RPG::EventCommand.new(116,@indent)
    @event_commands.push RPG::EventCommand.new(115,@indent)
  end

  #----------------------------------------------------------------------------
  # Cxgǉ
  #----------------------------------------------------------------------------
  def add(script_event)
    for command in script_event.event_commands
      command.indent += @indent
      @event_commands.push command
    end
  end

  #----------------------------------------------------------------------------
  # XNvgs
  #----------------------------------------------------------------------------
  def script(*args)
    @event_commands.push RPG::EventCommand.new(355,@indent,[*args])
  end

  #----------------------------------------------------------------------------
  # \bhĂяo
  #----------------------------------------------------------------------------
  def method_call(method,*args)
    script_text = "@parameters[1].call("
    if not args.empty?
      script_text << (0 ... args.size()).collect() {|i| "@parameters[#{i+2}]"}.join(",")
    end
    script_text << ")\ntrue"
    script(script_text,method,*args)
  end
end
