#==============================================================================
#  Matrix
#------------------------------------------------------------------------------
# }gNX
# Copyright (C) 2005 fukuyama
#==============================================================================

class MatrixBase
  attr_reader :label
  
  def initialize(dimension,size)
    @dimension = dimension
    @size = size
    @data = initialize_matrix
    @label = initialize_label
  end
  def initialize_matrix(d=0)
    if d < @dimension
      data = []
      for i in 0 ... @size
        data.push initialize_matrix(d + 1)
      end
      return data
    else
      return {}
    end
  end
  def initialize_label
    dimensionlabel = []
    for i in 0 ... @dimension
      label = []
      for i in 0 ... @size
        label.push i.to_s
      end
      dimensionlabel.push label
    end
    return dimensionlabel
  end
  def each_index(data=nil,*index,&block)
    if data.nil?
      data = @data
    end
    case data
    when Array
      data.each_index do |i|
        arg = index.dup
        arg.push i
        each_index(data[i],*arg,&block)
      end
    else
      yield(*index)
    end
  end
  def each_label(&block)
    each_index do |*index|
      label = []
      for d in 0 ... @dimension
        label.push @label[d][index[d]]
      end
      block.call(*label)
    end
  end
  def [](*index)
    data = @data
    for i in index
      data = data[i]
    end
    return data
  end
end
