# Game_Character }bv[vp
# Author:: fukuyama
# Date:: 2009/02/11
# Copyright:: Copyright (c) 2009 rgss-lib

class Game_Character
  #--------------------------------------------------------------------------
  #   X W̎擾
  #--------------------------------------------------------------------------
  def screen_x
    # Wƃ}bv̕\ʒuʍW߂
    return ($game_map.adjust_x(@real_x) + 3) / 4 + 16
  end
  #--------------------------------------------------------------------------
  #   Y W̎擾
  #--------------------------------------------------------------------------
  def screen_y
    # Wƃ}bv̕\ʒuʍW߂
    y = ($game_map.adjust_y(@real_y) + 3) / 4 + 32
    # WvJEgɉ Y W
    if @jump_count >= @jump_peak
      n = @jump_count - @jump_peak
    else
      n = @jump_peak - @jump_count
    end
    return y - (@jump_peak * @jump_peak - n * n) / 2
  end
  #--------------------------------------------------------------------------
  #   Z W̎擾
  #     height : LN^[̍
  #--------------------------------------------------------------------------
  def screen_z(height = 0)
    # őOʂɕ\tO ON ̏ꍇ
    if @always_on_top
      #  999
      return 999
    end
    # Wƃ}bv̕\ʒuʍW߂
    z = ($game_map.adjust_y(@real_y) + 3) / 4 + 32
    # ^C̏ꍇ
    if @tile_id > 0
      # ^C̃vCIeB * 32 𑫂
      return z + $game_map.priorities[@tile_id] * 32
    # LN^[̏ꍇ
    else
      #  32 𒴂Ă 31 𑫂
      return z + ((height > 32) ? 31 : 0)
    end
  end
  #--------------------------------------------------------------------------
  #  ʍs\
  #     x : X W
  #     y : Y W
  #     d :  (0,2,4,6,8)   0 = Sʍss̏ꍇ𔻒 (Wvp)
  #--------------------------------------------------------------------------
  def passable?(x, y, d)
    # VW߂
    new_x = x + (d == 6 ? 1 : d == 4 ? -1 : 0)
    new_y = y + (d == 2 ? 1 : d == 8 ? -1 : 0)
    new_x = $game_map.round_x(new_x)                        # [v␳
    new_y = $game_map.round_y(new_y)                        # c[v␳
    # W}bvȌꍇ
    unless $game_map.valid?(new_x, new_y)
      # ʍss
      return false
    end
    # 蔲 ON ̏ꍇ
    if @through
      # ʍs
      return true
    end
    # ړ̃^CwɏoȂꍇ
    unless $game_map.passable?($game_map.round_x(x), $game_map.round_y(y), d, self)
      # ʍss
      return false
    end
    # ړ̃^CɎwȂꍇ
    unless $game_map.passable?(new_x, new_y, 10 - d)
      # ʍss
      return false
    end
    # SCxg̃[v
    for event in $game_map.events.values
      # Cxg̍Wړƈvꍇ
      if event.x == new_x and event.y == new_y
        # 蔲 OFF Ȃ
        unless event.through
          # Cxg̏ꍇ
          if self != $game_player
            # ʍss
            return false
          end
          # vC[ŁÃOtBbNLN^[̏ꍇ
          if event.character_name != ""
            # ʍss
            return false
          end
        end
      end
    end
    # vC[̍Wړƈvꍇ
    if $game_player.x == new_x and $game_player.y == new_y
      # 蔲 OFF Ȃ
      unless $game_player.through
        # ̃OtBbNLN^[̏ꍇ
        if @character_name != ""
          # ʍss
          return false
        end
      end
    end
    # ʍs
    return true
  end
  #--------------------------------------------------------------------------
  #  Ɉړ
  #     turn_enabled : ̏ł̌ύXtO
  #--------------------------------------------------------------------------
  def move_down(turn_enabled = true)
    # 
    if turn_enabled
      turn_down
    end
    # ʍs\ȏꍇ
    if passable?(@x, @y, 2)
      # 
      turn_down
      # WXV
      @y = $game_map.round_y(@y+1)
      @real_y = (@y-1)*128
      # 
      increase_steps
    # ʍss\ȏꍇ
    else
      # ڐGCxg̋N
      check_event_trigger_touch(@x, @y+1)
    end
  end
  #--------------------------------------------------------------------------
  #  Ɉړ
  #     turn_enabled : ̏ł̌ύXtO
  #--------------------------------------------------------------------------
  def move_left(turn_enabled = true)
    # 
    if turn_enabled
      turn_left
    end
    # ʍs\ȏꍇ
    if passable?(@x, @y, 4)
      # 
      turn_left
      # WXV
      @x = $game_map.round_x(@x-1)
      @real_x = (@x+1)*128
      # 
      increase_steps
    # ʍss\ȏꍇ
    else
      # ڐGCxg̋N
      check_event_trigger_touch(@x-1, @y)
    end
  end
  #--------------------------------------------------------------------------
  #  EɈړ
  #     turn_enabled : ̏ł̌ύXtO
  #--------------------------------------------------------------------------
  def move_right(turn_enabled = true)
    # E
    if turn_enabled
      turn_right
    end
    # ʍs\ȏꍇ
    if passable?(@x, @y, 6)
      # E
      turn_right
      # WXV
      @x = $game_map.round_x(@x+1)
      @real_x = (@x-1)*128
      # 
      increase_steps
    # ʍss\ȏꍇ
    else
      # ڐGCxg̋N
      check_event_trigger_touch(@x+1, @y)
    end
  end
  #--------------------------------------------------------------------------
  #  Ɉړ
  #     turn_enabled : ̏ł̌ύXtO
  #--------------------------------------------------------------------------
  def move_up(turn_enabled = true)
    # 
    if turn_enabled
      turn_up
    end
    # ʍs\ȏꍇ
    if passable?(@x, @y, 8)
      # 
      turn_up
      # WXV
      @y = $game_map.round_y(@y-1)
      @real_y = (@y+1)*128
      # 
      increase_steps
    # ʍss\ȏꍇ
    else
      # ڐGCxg̋N
      check_event_trigger_touch(@x, @y-1)
    end
  end
end
