#==============================================================================
#  Window_Actor_Menu_Item
#------------------------------------------------------------------------------
# ACeAN^[j[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Actor_Menu_Item < Window_Actor_Menu_Base
    # VKQ[̏
    def self.new_game_handler(name)
      # XCb`ftHglŏ
      if Module.constants.include?('DEFAULT_ARRANGEMENT_ITEM')
        Switches['ǂ'] = DEFAULT_ARRANGEMENT_ITEM
      end
      if Module.constants.include?('DEFAULT_ARRANGEMENT_BACKPACK')
        Switches['ӂ됮'] = DEFAULT_ARRANGEMENT_BACKPACK
      end
    end
    Game_Handler.add('new_game',Window_Actor_Menu_Item.method(:new_game_handler))

    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def initialize(parent,title)
      super(parent,title)

      # j[ǉ
      add_menu('ӂ', :select_party_backpack)
      if Module.constants.include?('DEFAULT_ARRANGEMENT_ITEM')
        if Script_Config.switch('ǂ',DEFAULT_ARRANGEMENT_ITEM)
          add_menu('ǂ', :arrangement_item)
        end
      end
      if Module.constants.include?('DEFAULT_ARRANGEMENT_BACKPACK')
        if Script_Config.switch('ӂ됮',DEFAULT_ARRANGEMENT_BACKPACK)
          add_menu('ӂ됮', :arrangement_backpack)
        end
      end
      pack

      # ʒu̐ݒ
      rect = parent.menu_rect(parent.index)
      self.top = parent.top + rect.y
      self.left = parent.left

      # ACeEBhE쐬
      @window_item = Window_Item.new(self)
    end

    def change_actor
      if get_menu == 'ǂ' or get_menu == 'ӂ됮'
        @window_item.visible = false
      else
        @window_item.refresh
        @window_item.visible = true
        @window_item.index = -1 if not @window_item.active
      end
    end

    # ܂I
    def select_party_backpack
      if self.backpack.backpack.item_count != 0
        set_active_window(Window_Item)
        @window_item.index = 0
      end
    end

    # AN^[I
    def select_actor
      if self.actor.backpack.item_count != 0
        set_active_window(Window_Item)
        @window_item.index = Item_Facade.equip_items(self.actor).size
        if self.actor.backpack.item_count <= @window_item.index
          @window_item.index = self.actor.backpack.item_count - 1
        end
      end
    end

    # I
    def arrangement_item
      window = Window_Actor_Menu_Item_Arrange.new(self)
      set_active_window(window.class)
    end

    # ӂ됮I
    def arrangement_backpack
      window = Window_Backpack_Arrange.new(self)
      set_active_window(window.class)
    end
  end

end
