#==============================================================================
#  Window_Status_All
#------------------------------------------------------------------------------
# Xe[^XS
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Status_All < Window_Base
    # \
    include Sprite_Page_Arrow_Module
    include Event_Handling_Module
    include Window_Tree_Module
    #--------------------------------------------------------------------------
    #  IuWFNg
    #--------------------------------------------------------------------------
    def initialize(parent)
      @item_height = ITEM_HEIGHT
      @item_width = 110
      @item_space = 18
      @actor_index = 0
      @view_index = 0
      @view_max = 1
      w = _menu_width * 4
      h = @item_height * 14
      super(parent,0,0,w + 32,h + 32)
      self.back_opacity = WINDOW_BACK_OPACITY
      w = _menu_width * $game_party.actors.size
      h = @item_height * 14
      self.contents = Bitmap.new(w,h)
      refresh

      # TODO: ǉ
      # y[WiEj
      add_input_handler(DEFAULT_ALL_STATUS_PAGE_PREV_KEY,:page_prev)
      add_input_handler(DEFAULT_ALL_STATUS_PAGE_NEXT_KEY,:page_next)
      # \ؑցiJԂj
      # \͒lꗗ
      # {ꗗ
      add_input_handler(DEFAULT_ALL_STATUS_VIEW_PREV_KEY,:view_prev)
      add_input_handler(DEFAULT_ALL_STATUS_VIEW_NEXT_KEY,:view_next)

      add_input_handler(DEFAULT_ALL_STATUS_CLOSE_KEY,:close)

      # ʒu̐ݒ
      screen_center
    end

    def page_prev
      if @actor_index > 0
        @actor_index -= 1
        cursor_se # y[WςSE
        self.ox = @actor_index * _menu_width
      end
    end

    def page_next
      if (@actor_index + 4) < $game_party.actors.size
        @actor_index += 1
        cursor_se # y[WςSE
        self.ox = @actor_index * _menu_width
      end
    end

    def view_prev
      @view_index -= 1
      if @view_index < 0
        @view_index = @view_max
      end
    end

    def view_next
      @view_index += 1
      if @view_index > @view_max
        @view_index = 0
      end
    end

    # EBhE
    def close
      cancel_se
      dispose
    end

    #--------------------------------------------------------------------------
    #  tbV
    #--------------------------------------------------------------------------
    def draw_text(x,y,text,align)
      self.contents.draw_text(x, y, @item_width, @item_height, text, align)
      return x, y + @item_height
    end

    def refresh_actor(x,y,actor)
      w = @item_width
      h = @item_height
      c = self.contents
      status_system_color = self.system_color
      status_normal_color = self.normal_color

      c.font.color = status_normal_color

      # O
      (x,y) = draw_text(x,y, actor.name, 0)
      # go
      c.font.color = status_system_color
      (x,y) = draw_text(x,y, $data_system.words.hp, 0)
      c.font.color = status_normal_color
      (x,y) = draw_text(x,y, actor.hp.to_s, 2)
      c.fill_rect(x,y - 1,@item_width,2,status_normal_color)
      (x,y) = draw_text(x,y, actor.maxhp.to_s, 2)
      # lo
      c.font.color = status_system_color
      (x,y) = draw_text(x,y, $data_system.words.sp, 0)
      c.font.color = status_normal_color
      (x,y) = draw_text(x,y, actor.sp.to_s, 2)
      c.fill_rect(x,y - 1,@item_width,2,status_normal_color)
      (x,y) = draw_text(x,y, actor.maxsp.to_s, 2)
      # U
      c.font.color = status_system_color
      (x,y) = draw_text(x,y, $data_system.words.atk,0)
      c.font.color = status_normal_color
      (x,y) = draw_text(x,y, actor.base_atk.to_s,2)
      # h
      c.font.color = status_system_color
      (x,y) = draw_text(x,y, $data_system.words.pdef,0)
      c.font.color = status_normal_color
      (x,y) = draw_text(x,y, actor.base_pdef.to_s,2)
      # @h
      c.font.color = status_system_color
      (x,y) = draw_text(x,y, $data_system.words.mdef,0)
      c.font.color = status_normal_color
      (x,y) = draw_text(x,y, actor.base_mdef.to_s,2)
      # ku
      c.font.color = status_system_color
      c.draw_text(x, y, w, h, "Lv:", 0)
      c.font.color = status_normal_color
      c.draw_text(x, y, w, h, actor.level.to_s, 2)
    end

    def refresh
      if self.contents.nil?
        self.contents.clear
      end
      (x,y) = 0,0
      for actor in $game_party.actors
        refresh_actor(x,y,actor)
        x += _menu_width
      end
    end

    # t[XV
    def update
      return if self.disposed?
      super
      return if self.disposed?
      if self.active and @prev_active
        update_all_handler if self.active
      else
        update_handler
        @prev_active = self.active
      end
    end
    
    def _menu_width
      return @item_width + @item_space
    end    
  end

end
