#==============================================================================
#  Window_Status_Detail
#------------------------------------------------------------------------------
# AN^[ڍ׃Xe[^X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  
  #----------------------------------------------------------------------------
  #  ڍ׃Xe[^XEBhE
  #----------------------------------------------------------------------------
  class Window_Status_Detail < Window_Base
    #--------------------------------------------------------------------------
    #  IuWFNg
    #--------------------------------------------------------------------------
    def initialize(actor)
      @item_height = ITEM_HEIGHT
      super(0,0, 32 * 7 + 32, @item_height * 11 + 32)
      self.contents = Bitmap.new(self.width - 32, self.height - 32)
      @actor = actor
      @value_width = self.contents.text_size('00000').width
      refresh
    end
    #--------------------------------------------------------------------------
    #  AN^[̐ݒ
    #--------------------------------------------------------------------------
    def actor=(actor)
      if @actor != actor
        @actor = actor
        refresh
      end
    end
    #--------------------------------------------------------------------------
    #  tbV
    #--------------------------------------------------------------------------
    def draw_parameter(x,y,name,value)
      status_system_color = self.system_color
      status_normal_color = self.normal_color
      width = contents.width
      contents.font.color = status_system_color
      contents.draw_text(x,y,width - @value_width,@item_height,name + 'F',2)
      contents.font.color = status_normal_color
      contents.draw_text(x + width - @value_width,y,@value_width,@item_height,value.to_s,2)
      return x,(y+@item_height)
    end
    def refresh
      self.contents.clear
      return if @actor.nil?
      
       (x,y) = 0,0
      width = self.contents.width
      
      battler_image = RPG::Cache.battler(@actor.battler_name,@actor.battler_hue)
      self.contents.blt(x,y,battler_image,battler_image.rect,128)
      
       (x,y) = draw_parameter(x,y,$data_system.words.str,@actor.str)
       (x,y) = draw_parameter(x,y,$data_system.words.dex,@actor.dex)
       (x,y) = draw_parameter(x,y,$data_system.words.agi,@actor.agi)
       (x,y) = draw_parameter(x,y,$data_system.words.int,@actor.int)
       (x,y) = draw_parameter(x,y,'C',@actor.eva)
       (x,y) = draw_parameter(x,y,$data_system.words.atk,@actor.atk)
       (x,y) = draw_parameter(x,y,$data_system.words.pdef,@actor.pdef)
       (x,y) = draw_parameter(x,y,$data_system.words.mdef,@actor.mdef)
       (x,y) = draw_parameter(x,y,"ő#{$data_system.words.hp}",@actor.maxhp)
       (x,y) = draw_parameter(x,y,"ő#{$data_system.words.sp}",@actor.maxsp)
      
      status_system_color = self.system_color
      status_normal_color = self.normal_color
      
      rect = contents.text_size('ExF')
      contents.font.color = status_system_color
      contents.draw_text(x,y,rect.width,@item_height,'ExF',1)
      contents.font.color = status_normal_color
      contents.draw_text(x + rect.width,y,width - rect.width,@item_height,@actor.exp.to_s,2)
    end
  end
  
end
