#==============================================================================
#  Wizard_Equip
#------------------------------------------------------------------------------
# уEBU[h
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  
  class Wizard_Equip < ::DQ::Window_Page_Menu
    
    attr_accessor :window_help
    
    include Window_Tree_Module
    
    def initialize(parent,title,klass,kind = -1)
      @title = title
      @klass = klass
      @kind = kind
      @actor = nil
      @equip_item = nil
      create_menu
      super(parent)
      window_status_equip = get_window(Window_Status_Equip)
      self.visible = false
      self.top = top_window.top
      self.left = window_status_equip.right
      
      @window_help = nil
      @refresh_help_index = nil
    end
    def item
      item = get_menu
      if item.is_a?(String)
        return nil
      end
      return item
    end
    def input_b
      cancel_se
      window = get_window(Window_Actor_Menu_Equip)
      window.prev_page
    end
    #----------------------------------------------------------------------------
    # j[̍쐬
    #----------------------------------------------------------------------------
    def create_menu
      if not @actor.nil?
        items = []
        @actor.backpack.each_item do |item|
          if item.is_a?(@klass)
            if not Item_Facade.equippable?(item,@actor)
              next
            end
            if @klass == Game_Weapon
              items.push item
            elsif item.kind == @kind
              items.push item
            end
          end
        end
        items.each do |item|
          # ĂACe
          if Item_Facade.actor_equip?(item,@actor)
            add_menu(item,:menu_equip)
            @equip_item = item
          end
        end
        items.each do |item|
          # ĂȂACe
          if not Item_Facade.actor_equip?(item,@actor)
            add_menu(item,:menu_equip)
          end
        end
      end
      add_menu('тȂ',:menu_remove_equip)
    end
    #----------------------------------------------------------------------------
    # AN^[ݒ
    #----------------------------------------------------------------------------
    def actor=(actor)
      @actor = actor
      clear
      create_menu
      pack
      refresh_help
    end
    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def menu_equip
      item = get_menu
      actor = @actor
      # Œ肳Ăꍇ
      if Item_Facade.equip_fix?(item,actor)
        # ύX悤ƂĂꍇ
        if @equip_item != item
          buzzer_se
          return
        end
      end
      if (not actor.nil?) and (not item.nil?)
        actor.equip_item(item)
      end
      # SE
      equip_se
      window = get_window(Window_Actor_Menu_Equip)
      window.next_page
    end
    #----------------------------------------------------------------------------
    # Ȃ
    #----------------------------------------------------------------------------
    def menu_remove_equip
      item = @equip_item
      actor = @actor
      if (not actor.nil?) and (not item.nil?)
        # Œ肳Ăꍇ
        if Item_Facade.equip_fix?(item,actor)
          buzzer_se
          return
        end
        actor.remove_equip_item(item)
      end
      # SE
      equip_se
      window = get_window(Window_Actor_Menu_Equip)
      window.next_page
    end
    #--------------------------------------------------------------------------
    # XV
    #--------------------------------------------------------------------------
    def update
      super
      if @index != @refresh_help_index and @index >= 0
        refresh_help
        @refresh_help_index = @index
      end
    end
    #----------------------------------------------------------------------------
    # wv
    #----------------------------------------------------------------------------
    def refresh_help
      if (not @window_help.nil?) and (not @window_help.disposed?)
        if not self.item.nil?
          text = self.item.description.dup
          text << make_item_status_description
          org = Markup_New_Line.line_height
          Markup_New_Line.line_height = @window_help.line_height
          @window_help.set_text text
          Markup_New_Line.line_height = org
        else
          @window_help.set_text ''
        end
      end
    end
    def make_item_status_description
      return '' if @actor.nil?
      return '' if not @actor.is_a?(Game_Actor)
      return '' if item.is_a?(Game_Item)
      (a,b) = Item_Facade.equip_ability_calc(item,@actor)
      text = '\bottom'
      text << "\\right[#{a}  #{b}]#{a}  #{b}"
      return text
    end
    #--------------------------------------------------------------------------
    # ڂ̕`
    #--------------------------------------------------------------------------
    def draw_menu_item(index,color,rect,item)
      self.contents.font.color = color
      self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
      case item
      when String
        self.contents.draw_text(rect, item)
      else
        name = item.name
        # ĂACeH
        if Item_Facade.actor_equip?(item,@actor)
          name = 'E ' + name
        end
        self.contents.draw_text(rect, name)
      end
    end
    #---------------------------------------------------------------------------
    # Rec̍쐬
    def _contents_width
      return _menu_width * @column_max
    end
    #---------------------------------------------------------------------------
    # j[̍쐬
    def _menu_width
      return 32 * 7
    end
  end
  
end
