# Window_Message
# ͕\ɎgbZ[WEBhEłBiSprite_MessageΉj
#
# Author:: fukuyama
# Date:: 2006/08/15
# Copyright:: Copyright (c) 2006 fukuyama

class Window_Message
  attr_reader :sprite_message  # bZ[WXvCg
  attr_accessor :battle_message_position # 퓬̈ʒuݒ

  attr_accessor :fade_out_off # bZ[WEBhEtF[hAEgȂ
  attr_accessor :auto_message_interval # bZ[W\Ԋu

  attr_accessor :parallel # 

  # bZ[Wy[WL[
  MESSAGE_PAGE_NEXT_KEY = [Input::C] unless defined? MESSAGE_PAGE_NEXT_KEY

  # Ȉꍇ̕\̓EFCg
  WINDOW_MESSAGE_SELECT_INPUT_WAIT = 10 unless defined? WINDOW_MESSAGE_SELECT_INPUT_WAIT
  # l͂̏ꍇ̕\̓EFCg
  WINDOW_MESSAGE_NUMBER_INPUT_WAIT = 10 unless defined? WINDOW_MESSAGE_NUMBER_INPUT_WAIT

  # Recwix
  WINDOW_BACK_OPACITY = 160 unless defined? WINDOW_BACK_OPACITY

  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize
    line_height = Font.default_size + 2 # Ps̍
    line_max    = 4  # \s

    super(48, 16, 640 - 96, (line_height * line_max) + 32)
    self.visible = false
    self.z = 9998
    self.active = false
    self.index = -1
    @fade_in = false
    @fade_out = false
    @contents_showing = false
    @battle_message_position = 0 # 퓬̈ʒuݒ
    # bZ[WXvCg쐬
    @sprite_message = Sprite_Message.new(self.x + 12,
    self.y + 16,
    self.width - 24,
    self.height - 32,
    line_max)
    # EBhẼtHgJ[ɍ킹
    @sprite_message.bitmap.font.color = normal_color
    @input_wait = 0
    @parallel = false
    @auto_message_interval = nil
    @auto_message_interval_count = 0
  end

  #--------------------------------------------------------------------------
  #  
  #--------------------------------------------------------------------------
  def dispose
    terminate_message
    $game_temp.message_window_showing = false
    if @input_number_window != nil
      @input_number_window.dispose
    end
    # bZ[WXvCgJ
    @sprite_message.dispose
    super
  end

  #--------------------------------------------------------------------------
  #  IEBhE̍쐬
  #--------------------------------------------------------------------------
  def create_window_message_command
    return Window_Message_Command.new
  end

  #--------------------------------------------------------------------------
  #  l̓EBhE̍쐬
  #--------------------------------------------------------------------------
  def create_window_message_input_number
    window = Window_Message_InputNumber.new($game_temp.num_input_digits_max)
    window.number = $game_variables[$game_temp.num_input_variable_id]
    return window
  end

  #--------------------------------------------------------------------------
  #  S[hEBhE̍쐬
  #--------------------------------------------------------------------------
  def create_gold_window
    if @gold_window == nil
      @gold_window = Window_Gold.new
      @gold_window.x = 640 - @gold_window.width - 16
      #@gold_window.x = self.right - @gold_window.width
      if $game_temp.in_battle
        @gold_window.y = 192
      else
        @gold_window.y = self.y >= 128 ? 16 : 384
        #@gold_window.y = self.y >= 128 ? 32 : 384
      end
      @gold_window.opacity = self.opacity
      @gold_window.back_opacity = self.back_opacity
    end
  end

  #--------------------------------------------------------------------------
  #  bZ[WI
  #--------------------------------------------------------------------------
  def terminate_message
    self.active = false
    self.pause = false
    self.index = -1
    @sprite_message.terminate_message
    # \tONA
    @contents_showing = false
    # bZ[W R[obNĂ
    if $game_temp.message_proc != nil
      $game_temp.message_proc.call
    end
    # ́AIAl͂ɊւϐNA
    $game_temp.message_text = nil
    $game_temp.message_proc = nil
    $game_temp.choice_start = 99
    $game_temp.choice_max = 0
    $game_temp.choice_cancel_type = 0
    $game_temp.choice_proc = nil
    $game_temp.num_input_start = 99
    $game_temp.num_input_variable_id = 0
    $game_temp.num_input_digits_max = 0
    # S[hEBhEJ
    if @gold_window != nil
      @gold_window.dispose
      @gold_window = nil
    end
    # IEBhEJ
    if @command_window != nil
      @command_window.dispose
      @command_window = nil
    end
    if Module.constants.include?('Markup_Graphics_Face')
      Markup_Graphics_Face.face_window_close
    end
  end

  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def refresh
    # \҂̃bZ[Wꍇ
    if $game_temp.message_text != nil
      @sprite_message.message = $game_temp.message_text
    end
    # Ȉꍇ
    if $game_temp.choice_max > 0
      # IEBhE쐬
      @command_window = create_window_message_command
      @command_window.visible = false
      @command_window.active = false
      @command_window.z = self.z
      @input_wait = WINDOW_MESSAGE_SELECT_INPUT_WAIT
      layout_window @command_window
    end
    # l͂̏ꍇ
    if $game_temp.num_input_variable_id > 0
      @input_number_window = create_window_message_input_number
      @input_number_window.visible = false
      @input_number_window.active = false
      @input_number_window.z = self.z
      @input_wait = WINDOW_MESSAGE_NUMBER_INPUT_WAIT
      layout_window @input_number_window
    end
  end

  #--------------------------------------------------------------------------
  #  EBhËʒuƕsx̐ݒ
  #--------------------------------------------------------------------------
  def reset_window
    if $game_temp.in_battle
      case @battle_message_position
      when 0  # 
        self.y = 16
      when 1  # 
        self.y = 160
      when 2  # 
        self.y = 480 - self.height - 16
      end
    else
      case $game_system.message_position
      when 0  # 
        self.y = 16
      when 1  # 
        self.y = 160
      when 2  # 
        self.y = 480 - self.height - 16
      end
    end
    if $game_system.message_frame == 0
      self.opacity = 255
    else
      self.opacity = 0
    end
    @sprite_message.y = self.y + 16
    self.back_opacity = WINDOW_BACK_OPACITY
  end

  #--------------------------------------------------------------------------
  #  ̑EBhËʒuƕsx̐ݒ
  #--------------------------------------------------------------------------
  def layout_window(window)
    if window.nil?
      return
    end
    window.opacity = self.opacity
    window.back_opacity = self.back_opacity

    if self.y > 480 / 2
      # ɂ
      window.bottom = self.top
      window.right  = self.right
    else
      # ɂ
      window.top  = self.bottom
      window.left = self.left
    end
  end

  def x=(n)
    tmp = n - self.x
    super(n)
    @sprite_message.x += tmp if not @sprite_message.nil?
  end

  def y=(n)
    tmp = n - self.y
    super(n)
    @sprite_message.y += tmp if not @sprite_message.nil?
  end

  def z=(n)
    super(n)
    @sprite_message.z = self.z + 1 if not @sprite_message.nil?
  end

  def skip?
    return @sprite_message.skip? if not @sprite_message.nil?
    return false
  end

  def auto_message_interval=(auto_message_interval)
    @auto_message_interval = auto_message_interval
    if @auto_message_interval.nil?
      @auto_message_interval_count = 0
    else
      @auto_message_interval_count = @auto_message_interval
    end
  end

  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    super
    # tF[hC̏ꍇ
    if @fade_in
      self.contents_opacity += 48
      if self.contents_opacity == 255
        @fade_in = false
      end
      @sprite_message.visible = self.visible
      @sprite_message.opacity = self.contents_opacity
      return
    end
    # bZ[WXvCgXV
    if @sprite_message.showing?
      @sprite_message.update
      return
    end
    # l̓EBhE̍XV
    if not @input_number_window.nil?
      if not @input_number_window.active
        $game_system.se_play(@input_number_window_se)
        @input_number_window.visible = true
        @input_number_window.active = true
      end
      @input_number_window.update
      if @input_wait > 0
        @input_wait -= 1
      else
        # 
        if Input.trigger?(Input::C)
          $game_system.se_play($data_system.decision_se)
          $game_variables[$game_temp.num_input_variable_id] = @input_number_window.number
          $game_map.need_refresh = true
          # l̓EBhE
          @input_number_window.dispose
          @input_number_window = nil
          terminate_message
        elsif @input_number_window.cancel_enable?
          # LZ
          if Input.trigger?(Input::B)
            $game_system.se_play($data_system.cancel_se)
            $game_variables[$game_temp.num_input_variable_id] = @input_number_window.cancel_number
            $game_map.need_refresh = true
            # l̓EBhE
            @input_number_window.dispose
            @input_number_window = nil
            terminate_message
          end
        end
      end
      return
    end
    # IEBhEXV
    if not @command_window.nil?
      if not @command_window.active
        $game_system.se_play(@command_window_popup_se)
        @command_window.visible = true
        @command_window.active = true
      end
      @command_window.update
    end
    # bZ[W\̏ꍇ
    if @contents_showing
      # Iꍇ
      if $game_temp.choice_max == 0
        # I[g[hݒ肳Ȃꍇ́A|[YTC\
        if @auto_message_interval.nil?
          self.pause = true
        end
        if @sprite_message.skip?
          terminate_message
          return
        end
      end

      if $game_temp.choice_max > 0
        if @input_wait > 0
          @input_wait -= 1
        else
          # IL
          if Input.trigger?(Input::B) and $game_temp.choice_cancel_type > 0
            # LZ
            $game_system.se_play($data_system.cancel_se)
            $game_temp.choice_proc.call($game_temp.choice_cancel_type - 1)
            terminate_message
          elsif Input.trigger?(Input::C)
            # 
            $game_system.se_play($data_system.decision_se)
            $game_temp.choice_proc.call(@command_window.index)
            terminate_message
          end
        end
      else
        # I
        if MESSAGE_PAGE_NEXT_KEY.any? {|k| Input.trigger?(k)}
          # y[W
          terminate_message
        end
      end

      if not @auto_message_interval.nil?
        if @auto_message_interval_count <= 0
          terminate_message
          @auto_message_interval_count = @auto_message_interval
        else
          @auto_message_interval_count -= 1
        end
      end
      return
    end
    # tF[hAEgȊOŕ\҂̃bZ[WIꍇ
    if @fade_out == false and $game_temp.message_text != nil
      @contents_showing = true
      unless @parallel
        $game_temp.message_window_showing = true
        @parallel = false
      end
      reset_window
      refresh
      Graphics.frame_reset
      if not self.visible
        @fade_in = true
        self.visible = true
        self.contents_opacity = 0
      end
      return
    end
    # \ׂbZ[WȂAEBhEԂ̏ꍇ
    if self.visible
      if @fade_out_off and (not @fade_out)
        $game_temp.message_window_showing = false
        return
      end
      @fade_out = true
      self.opacity -= 48
      @sprite_message.opacity = self.opacity
      if self.opacity == 0
        self.visible = false
        @sprite_message.visible = false
        @sprite_message.clear
        @fade_out = false
        $game_temp.message_window_showing = false
      end
      return
    end
  end
end
