#==============================================================================
#  Scene_Title
#------------------------------------------------------------------------------
# cpp^Cgj[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Scene_Title < Scene_Base
    include Data_Loader
    def self.menu_window=(b)
      if $scene.is_a?(Scene_Title)
        $scene.menu_window = b
      end
    end

    def menu_window=(b)
      if b
        @menu_window = Window_Title_Menu.new
      else
        @menu_window = nil
      end
    end

    @@title_map_id = nil

    def get_title_map_id()
      if @@title_map_id.nil?
        @@title_map_id = DEFAULT_TITLE_MAP_ID
        data_map_infos.each_key do |index|
          next if data_map_infos[index].nil?
          if data_map_infos[index].name == '^Cg'
            @@title_map_id = index
            break
          end
        end
      end
      return @@title_map_id
    end

    def main_start
      $game_temp          = Game_Temp.new
      $game_system        = Game_System.new
      $game_switches      = Game_Switches.new
      $game_variables     = Game_Variables.new
      $game_self_switches = Game_SelfSwitches.new
      $game_screen        = Game_Screen.new
      $game_actors        = Game_Actors.new
      $game_party         = Game_Party.new
      $game_troop         = Game_Troop.new
      $game_player        = Game_Player.new

      map_id = get_title_map_id()

      # }bvIuWFNg쐬
      $game_map = Game_Map.new
      # }bvZbgAbv
      $game_map.setup(map_id)
      # BGM ύX
      $game_map.autoplay

      # XvCgZbg쐬
      @spriteset = Spriteset_Map.new
      # bZ[WEBhE쐬
      @message_window = Window_Message.new
      # j[EBhE쐬
      Scene_Title.menu_window = DEFAULT_TITLE_MENU

      # Train_ActorΉ
      $game_party.update_party_actors

      # pCxgs
      $game_map.update
      $game_system.map_interpreter.update
      $game_screen.update
      @spriteset.update
      super
    end

    def main_end
      # XvCgZbg̍폜
      @spriteset.dispose
      # bZ[WEBhE폜
      @message_window.dispose
      # j[EBhE̍폜
      unless @menu_window.nil?
        if not @menu_window.disposed?
          @menu_window.dispose
        end
      end
      super
    end

    def update
      $game_map.update
      $game_system.map_interpreter.update
      $game_screen.update
      # XvCgZbgXV
      @spriteset.update
      # bZ[WEBhEXV
      @message_window.update
      # bZ[WEBhE\̏ꍇ
      if $game_temp.message_window_showing
        return
      end
      unless @menu_window.nil?
        # j[EBhEXV
        @menu_window.update
        if @menu_window.disposed?
          $scene = ::Scene_Title.new
        end
      end
    end
  end

end
