#==============================================================================
#  Game_Armor
#------------------------------------------------------------------------------
# hACeNX
# Copyright (C) 2005 fukuyama
#==============================================================================

class Game_Armor < Game_Item_Base
  include Game_Item_Ability_Plus_Module
  include Game_Item_Equip_Module

  # (0:A1:hA2:g̖hA3:i)
  SHIELD_KIND      = 0
  HELM_KIND        = 1
  ARMOR_KIND       = 2
  ACCESSORIES_KIND = 3

  def initialize(id = nil)
    @kind = 0
    @auto_state_id = 0
    @eva = 0
    @guard_element_set = []
    @guard_state_set = []
    super()
    setup($data_armors[id]) if not id.nil?
  end

  def setup(item)
    super(item)
    @kind              = item.kind
    @auto_state_id     = item.auto_state_id
    @eva               = item.eva
    @guard_element_set = item.guard_element_set.dup
    @guard_state_set   = item.guard_state_set.dup
  end

  attr_accessor :kind
  attr_accessor :auto_state_id
  attr_accessor :eva
  attr_accessor :guard_element_set
  attr_accessor :guard_state_set

end
