#==============================================================================
#  Game_Item
#------------------------------------------------------------------------------
# ACeNX
# Copyright (C) 2005 fukuyama
#==============================================================================

class Game_Item < Game_Item_Base
  include Game_Item_Animation_Module
  def initialize(id = nil)
    @scope = 0
    @occasion = 0
    @menu_se = RPG::AudioFile.new("", 80)
    @common_event_id = 0
    @consumable = true
    @parameter_type = 0
    @parameter_points = 0
    @recover_hp_rate = 0
    @recover_hp = 0
    @recover_sp_rate = 0
    @recover_sp = 0
    @hit = 100
    @pdef_f = 0
    @mdef_f = 0
    @variance = 0
    @element_set = []
    @plus_state_set = []
    @minus_state_set = []
    super()
    setup($data_items[id]) if not id.nil?
  end

  def setup(item)
    super(item)
    @scope            = item.scope
    @occasion         = item.occasion
    @menu_se          = item.menu_se
    @common_event_id  = item.common_event_id
    @price            = item.price
    @consumable       = item.consumable
    @parameter_type   = item.parameter_type
    @parameter_points = item.parameter_points
    @recover_hp_rate  = item.recover_hp_rate
    @recover_hp       = item.recover_hp
    @recover_sp_rate  = item.recover_sp_rate
    @recover_sp       = item.recover_sp
    @hit              = item.hit
    @pdef_f           = item.pdef_f
    @mdef_f           = item.mdef_f
    @variance         = item.variance
    @element_set      = item.element_set.dup
    @plus_state_set   = item.plus_state_set.dup
    @minus_state_set  = item.minus_state_set.dup
  end

  attr_accessor :scope
  attr_accessor :occasion
  attr_accessor :menu_se
  attr_accessor :common_event_id
  attr_accessor :price
  attr_accessor :consumable
  attr_accessor :parameter_type
  attr_accessor :parameter_points
  attr_accessor :recover_hp_rate
  attr_accessor :recover_hp
  attr_accessor :recover_sp_rate
  attr_accessor :recover_sp
  attr_accessor :hit
  attr_accessor :pdef_f
  attr_accessor :mdef_f
  attr_accessor :variance
  attr_accessor :element_set
  attr_accessor :plus_state_set
  attr_accessor :minus_state_set

  # occasion gp\ (0:펞A1:oĝ݁A2:j[̂݁A3:gps) B
  def use_battle?
    return (@occasion == 0 or @occasion == 1)
  end

  def use_menu?
    return (@occasion == 0 or @occasion == 2)
  end

  #(0:ȂA1:GṔA2:GŚA3:ṔA4:ŚA5:P (HP 0) A6:S (HP 0) A7:gp)

  # ͈͂ȂH
  def scope_nil?
    return (@scope == 0)
  end

  # P̃ACeH
  def scope_single?
    return ((@scope % 2) == 1)
  end

  # S̃ACeH
  def scope_all?
    return (@scope != 0 and (@scope % 2) == 0)
  end

  # gp҃ACeH
  def scope_self?
    return (@scope == 7)
  end

  # HP0ACeH
  def scope_hp0?
    return (@scope == 5 and @scope == 6)
  end

  # Gւ̃ACeH
  def scope_enemy?
    return (@scope != 0 and @scope <= 2)
  end

  # ւ̃ACeH
  def scope_friend?
    return (@scope >= 3)
  end

  # _[WACeH
  def damage_item?
    return (damage_hp_item? or damage_sp_item?)
  end

  # HP_[WACeH
  def damage_hp_item?
    return (@recover_hp_rate < 0 or @recover_hp < 0)
  end

  # SP_[WACeH
  def damage_sp_item?
    return (@recover_sp_rate < 0 or @recover_sp < 0)
  end

  # 񕜃ACeH
  def recover_item?
    return (recover_hp_item? or recover_sp_item?)
  end

  # HP񕜃ACeH
  def recover_hp_item?
    return (@recover_hp_rate > 0 or @recover_hp > 0)
  end

  # SP񕜃ACeH
  def recover_sp_item?
    return (@recover_sp_rate > 0 or @recover_sp > 0)
  end

  # Xe[gωACeH
  def state_change_item?
    return (state_add_item? or state_cancel_item?)
  end

  # Xe[gtACeH
  def state_add_item?
    return (not @plus_state_set.empty?)
  end

  # Xe[gACeH
  def state_cancel_item?
    return (not @minus_state_set.empty?)
  end

  # sACeH
  def action_blockade_item?
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      #  (0:ȂA1:@gpłȂA2:GʏUA3:ʏUA4:słȂ)
      if state.restriction == 4
        return true
      end
    end
    return false
  end

  # @ACeH
  def magic_blockade_item?
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      #  (0:ȂA1:@gpłȂA2:GʏUA3:ʏUA4:słȂ)
      if state.restriction == 1
        return true
      end
    end
    return false
  end

  # U̓Abv
  def attack_up_item?
    str_rate = 100.0
    atk_rate = 100.0
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      str_rate *= state.str_rate / 100.0
      atk_rate *= state.atk_rate / 100.0
    end
    return (str_rate > 100.0 or atk_rate > 100.0)
  end

  # U̓_E
  def attack_down_item?
    str_rate = 100.0
    atk_rate = 100.0
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      str_rate *= state.str_rate / 100.0
      atk_rate *= state.atk_rate / 100.0
    end
    return (str_rate < 100.0 or atk_rate < 100.0)
  end

  # h̓Abv
  def pdef_up_item?
    pdef_rate = 100.0
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      pdef_rate *= state.pdef_rate / 100.0
    end
    return (pdef_rate > 100.0)
  end

  # h̓_E
  def pdef_down_item?
    pdef_rate = 100.0
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      pdef_rate *= state.pdef_rate / 100.0
    end
    return (pdef_rate < 100.0)
  end

  # ̓Abv
  def hit_up_item?
    hit_rate = 100.0
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      hit_rate *= state.hit_rate / 100.0
    end
    return (hit_rate > 100.0)
  end

  # ̓_E
  def hit_down_item?
    hit_rate = 100.0
    @plus_state_set.each do |state_id|
      state = $data_states[state_id]
      hit_rate *= state.hit_rate / 100.0
    end
    return (hit_rate < 100.0)
  end

end
