def bezier_point(pts, t)
  d = pts.length - 1
  if d < 1
    return nil
  end

  t1 = 1.0 - t
  fact = 1.0
  n = 1

  x = pts[0][0] * t1
  y = pts[0][1] * t1

  for i in 1 ... d
    fact = fact * t
    n = n * (d - i + 1) / i
    fn = fact * n
    x = (x + fn * pts[i][0]) * t1
    y = (y + fn * pts[i][1]) * t1
  end

  x = x + fact * t * pts[d][0]
  y = y + fact * t * pts[d][1]
  [x,y]
end # def bezier(pts, t)

def bezier_points(pts,l)
  rpts = []
  cur = 1.0
  t = 1.0 / l
  pt1 = nil
  for i in 0 .. l
    pt2 = bezier_point(pts,i * t)
    while (not pt1.nil?) and pt1[0] <= cur and cur <= pt2[0]
      rpts.push [cur.to_i,((pt2[1] - pt1[1]) / (pt2[0] - pt1[0]) * (cur - pt1[0]) + pt1[1]).to_i]
      cur += 1.0
    end
    pt1 = pt2
  end
  rpts
end

pts = [
  [1,10],[50,200],[99,256]
]

bezier_points(pts,99).each do |pt|
  puts pt.join("\t")
end
