# $Id: Window.rb,v 1.1 2005/09/30 15:23:26 yf30 Exp $
#==============================================================================
#  Window
#------------------------------------------------------------------------------
# EBhENXĒ`
#==============================================================================

class Window
  attr_reader :viewport
  
  attr_accessor :windowskin
  attr_accessor :contents
  attr_accessor :stretch
  attr_accessor :cursor_rect
  attr_accessor :active
  attr_accessor :visible
  attr_accessor :pause
  
  attr_accessor :x
  attr_accessor :y
  attr_accessor :width
  attr_accessor :height

  attr_accessor :z
  
  attr_accessor :ox
  attr_accessor :oy

  attr_accessor :opacity
  attr_accessor :back_opacity
  attr_accessor :contents_opacity

  class Padding
    attr_accessor :top
    attr_accessor :right
    attr_accessor :bottom
    attr_accessor :left
    def initialize(n)
      @top = n
      @right = n
      @bottom = n
      @left = n
    end
  end
  class Border
    TOP    = 8
    RIGHT  = 6
    BOTTOM = 2
    LEFT   = 4
    CENTER = 5
    TOP_RIGHT    = 9
    TOP_LEFT     = 7
    BOTTOM_RIGHT = 3
    BOTTOM_LEFT  = 1
    IDS = [1,2,3,4,5,6,7,8,9]
    
    class Border_Sprite < Sprite
      def initialize(viewport = nil)
        super(viewport)
      end
    end
    
    attr_accessor :windowskin
    attr_accessor :width
    attr_accessor :skin_rects

    def initialize(viewport = nil)
      @sprites = {}
      for i in IDS
        @sprites[i] = Border_Sprite.new(viewport)
      end
      @windowskin = nil
      @width = 16
      
      @skin_rects = {}
      self.skin_rects = Rect.new(128,0,64,64)
      self.skin_rects[CENTER] = Rect.new(2,2,124,124)
    end
    def top
      @sprites[TOP]
    end
    def right
      @sprites[RIGHT]
    end
    def bottom
      @sprites[BOTTOM]
    end
    def left
      @sprites[LEFT]
    end
    def center
      @sprites[CENTER]
    end
    def top_right
      @sprites[TOP_RIGHT]
    end
    def top_left
      @sprites[TOP_LEFT]
    end
    def bottom_right
      @sprites[BOTTOM_RIGHT]
    end
    def bottom_left
      @sprites[BOTTOM_LEFT]
    end
    def dispose
      @sprites.each_value do |sprite|
        sprite.dispose
      end
    end
    def skin_rects=(rect)
      t = rect.y
      l = rect.x
      b = rect.y + rect.height - self.width
      r = rect.x + rect.width - self.width
      w = self.width
      h = self.width
      @skin_rects[TOP_LEFT]     = Rect.new(l, t, w, h)
      @skin_rects[TOP_RIGHT]    = Rect.new(r, t, w, h)
      @skin_rects[BOTTOM_LEFT]  = Rect.new(l, b, w, h)
      @skin_rects[BOTTOM_RIGHT] = Rect.new(r, b, w, h)
      @skin_rects[TOP]          = Rect.new(l + w, t, r - l - w, h)
      @skin_rects[BOTTOM]       = Rect.new(l + w, b, r - l - w, h)
      @skin_rects[LEFT]         = Rect.new(l, t + h, w, b - t - h)
      @skin_rects[RIGHT]        = Rect.new(r, t + h, w, b - t - h)
    end
    def create_bitmap(sprite,w,h)
      if not sprite.bitmap.nil?
        sprite.bitmap.dispose
      end
      sprite.bitmap = Bitmap.new(w,h)
    end
    def visible=(v)
      @sprites.each_value do |sprite|
        sprite.visible = v
      end
    end
    def z=(n)
      @sprites.each_value do |sprite|
        sprite.z = n + 1
      end
      @sprites[CENTER].z = n
    end
    def visible
      top.visible
    end
    def setup_skin(sprite,rect)
      create_bitmap(sprite,rect.width,rect.height)
      sprite.bitmap.blt(0, 0, windowskin, rect)
    end
    def windowskin=(skin)
      return if skin.nil?
      return if not skin.is_a?(Bitmap)
      @windowskin = skin
      for i in IDS
        setup_skin(@sprites[i], @skin_rects[i])
      end
    end
    def move(rect)
      top.x    = rect.x + top_left.bitmap.width
      top.y    = rect.y
      right.x  = rect.x + rect.width - right.bitmap.width
      right.y  = rect.y + top_right.bitmap.height
      bottom.x = rect.x + bottom_left.bitmap.width
      bottom.y = rect.y + rect.height - bottom.bitmap.height
      left.x   = rect.x
      left.y   = rect.y + top_left.bitmap.height
      center.x = rect.x + 2
      center.y = rect.y + 2
      top_right.x = rect.x + rect.width - top_right.bitmap.width
      top_right.y = rect.y
      top_left.x  = rect.x
      top_left.y  = rect.y
      bottom_right.x = rect.x + rect.width - bottom_right.bitmap.width
      bottom_right.y = rect.y + rect.height - bottom_right.bitmap.height
      bottom_left.x  = rect.x
      bottom_left.y  = rect.y + rect.height - bottom_left.bitmap.height
    end
    def resize_width(sprite,width)
      if width < 0
        return
      end
      if width != sprite.bitmap.width
        sprite.zoom_x = width.to_f / sprite.bitmap.width.to_f
      end
    end
    def resize_height(sprite,height)
      if height < 0
        return
      end
      if height != sprite.bitmap.height
        sprite.zoom_y = height.to_f / sprite.bitmap.height.to_f
      end
    end
    def resize(rect)
      w = rect.width - top_right.bitmap.width - top_left.bitmap.width
      resize_width(top,w)
      w = rect.width - bottom_right.bitmap.width - bottom_left.bitmap.width
      resize_width(bottom,w)
      h = rect.height - top_right.bitmap.height - bottom_right.bitmap.height
      resize_height(right,h)
      h = rect.height - top_left.bitmap.height - bottom_left.bitmap.height
      resize_height(left,h)
      w = rect.width - 2 - 2
      h = rect.height - 2 - 2
      if w != center.bitmap.width or h != center.bitmap.height
        center.zoom_x = w.to_f / center.bitmap.width.to_f
        center.zoom_y = h.to_f / center.bitmap.height.to_f
      end
      move(rect)
    end
  end
  class Cursor < Border
    def initialize(viewport = nil)
      super(viewport)
      self.width = 2
      self.skin_rects = Rect.new(128,64,32,32)
      self.skin_rects[CENTER] = Rect.new(128+2,64+2,32-4,32-4)
      self.visible = false
    end
  end

  def initialize(viewport = nil)
    @viewport = viewport
    @windowskin = nil
    @contents = nil
    @stretch = true
    @cursor_rect = Rect.new(0,0,0,0)
    @active = true
    @visible = true
    @pause = true

    @x = 0
    @y = 0
    @width = 0
    @height = 0

    @z = 0
    
    @ox = 0
    @oy = 0

    @border = Border.new(@viewport)
    @cursor = Cursor.new(@viewport)
    @padding = Padding.new(16)
    @contents_sprite = Sprite.new(@viewport)
    
    @border.z = @z
    @cursor.z = @z + 4
    @contents_sprite.z = @z + 2
  end
  def dispose
    @border.dispose
    @cursor.dispose
    @contents_sprite.dispose
  end
  def disposed?
    return @border.dispose?
  end
  def update
    if @cursor_rect.width == 0
      @cursor.visible = false
    else
      if self.visible
        @cursor.visible = true
        @cursor.resize(Rect.new(
          self.x + @cursor_rect.x + @padding.left,
          self.y + @cursor_rect.y + @padding.top,
          @cursor_rect.width,
          @cursor_rect.height
        ))
      end
    end
  end
  
  def contents=(c)
    @contents = c
    @contents_sprite.bitmap = @contents
  end
  
  def windowskin=(skin)
    @windowskin = skin
    @border.windowskin = skin
    @cursor.windowskin = skin
  end
  def move()
    @border.move(self)
    @cursor.move(self)
    @contents_sprite.x = x + @padding.left
    @contents_sprite.y = y + @padding.top
  end
  def resize()
    @border.resize(self)
    @contents_sprite.src_rect.set(ox,oy,width,height)
  end
  def x=(n)
    @x = n
    move()
  end
  def y=(n)
    @y = n
    move()
  end
  def z=(n)
    @z = n
    @border.z = n
    @cursor.z = n + 4
    @contents_sprite.z = n + 2
  end
  def width=(n)
    @width = n
    resize()
  end
  def height=(n)
    @height = n
    resize()
  end
  def visible=(v)
    @visible = v
    @border.visible = v
    @contents_sprite.visible = v
  end
  def back_opacity=(n)
    @border.center.opacity = n
  end
  def back_opacity()
    return @border.center.opacity
  end
  def opacity=(n)
    if n < 0
      @opacity = 0
    elsif 255 < n
      @opacity = 255
    else
      @opacity = n
    end
  end
  def contents_opacity=(n)
    if n < 0
      @contents_opacity = 0
    elsif 255 < n
      @contents_opacity = 255
    else
      @contents_opacity = n
    end
  end
end
