require 'rexml/document'

module DBC
  class Data_Compiler
    attr_accessor :value_creator
    def initialize(filename)
      @filename = filename
      @cache = {}
      @value_creator = Default_Value_Creator.new(self)
      @section_data = {} # ZNVf[^̃LbV
      @properties = {} # vpeBf[^̃LbV
    end

    def compile_csv(csvfilename,name,col_names)
      section = load_section(name)
      data = get_data_cols(section,col_names)
      File.open(csvfilename,'w+') do |file|
        data.each() do |d|
          file.puts d.join(',')
        end
      end
      return data
    end

    def compile_properties(csvfilename,name,col_names)
      props = get_properties(name)[col_names[0]]
      File.open(csvfilename,'w+') do |file|
        file.puts col_names.join(',')
        props.keys().sort().each() do |k|
          d = props[k]
          vals = []
          col_names.each() do |nm|
            vals.push(d[nm])
          end
          if not vals[1,vals.size].all?(){|o| o.nil? or o.to_s.empty?}
            file.puts vals.join(',')
          end
        end
      end
      return props
    end

    def load_fods(name=nil)
      @cache['load_fods'] = {} unless @cache.member?('load_fods')
      if @cache['load_fods'].member?(name)
        return @cache['load_fods'][name]
      end
      dom_key = '_load_fods_dom_'+@filename
      unless @cache.member?(dom_key)
        file = nil
        begin
          file = File.new(@filename)
          @cache[dom_key] = REXML::Document.new(file)
        ensure
        file.close() if not file.nil?
        file = nil
        end
      end
      xpath = "*/office:body/office:spreadsheet/table:table"
      unless name.nil?
        xpath = "*/office:body/office:spreadsheet/table:table[@name=\"#{name}\"]"
      end
      @cache[dom_key].elements().each(xpath) do |t|
        @cache['load_fods'][t.attributes['name']] = _load_table_element(t)
      end
      if name.nil?
        return @cache['load_fods']
      else
        return @cache['load_fods'][name]
      end
    end

    # ZNVf[^ǂݍ
    def load_section(name)
      Debug.log('load_section: start ' + name) if $TRACE
      if not @section_data.member?(name)
        res = nil
        case File.extname(@filename)
        when '.fods'
          res = load_fods(name)
        end
        if res.nil?
          raise Exception.new("unsupport file.(#{@filename}:#{name}))")
        end
        if res.empty?
          raise Exception.new("not found.(#{@filename}:#{name})")
        end
        res = remove_comment(res)
        @section_data[name] = transfer_section(res)
      end
      Debug.log('load_section: end') if $TRACE
      return @section_data[name]
    end

    def get_properties(name)
      if not @properties.member?(name)
        section_data = load_section(name)
        @properties[name] = create_properties_container(section_data)
      end
      return @properties[name]
    end

    def get_section_keys(section)
      names = section['name'].flatten()
      keys = []
      l = section['key'].flatten()
      l.each_index() do |i|
        if (not l[i].nil?) and (not l[i].empty?)
        keys.push(names[i])
        end
      end
      return keys
    end

    def get_data_cols(section,col_names)
      result = []
      names = section['name'].flatten()
      types = section['type'].flatten()
      data = section['data']
      data.each() do |values|
        cols = []
        _each_transfer(names,types,values,false) do |name,type,val|
          if col_names.member?(name)
            cols.push(val)
          end
        end
        result.push(cols)
      end
      return result
    end

    # ef[^̐擪̕񂪃RgȂ炻̃f[^폜
    def remove_comment(data,comment_prefix = '#')
      case data
      when Hash
        data.keys().each() do |key|
          if key.is_a?(String) and key =~ /^#{comment_prefix}/
          data.delete(key)
          else
            remove_comment(data[key],comment_prefix)
            if data[key].empty?
            data.delete(key)
            end
          end
        end
      when Array
        if data[0].is_a?(String) and data[0] =~ /^#{comment_prefix}/
        data.clear()
        else
          data.delete_if() do |obj|
            if obj.is_a?(Array) or obj.is_a?(Hash)
              remove_comment(obj,comment_prefix)
            obj.empty?
            else
              obj.is_a?(String) and obj =~ /^#{comment_prefix}/
            end
          end
        end
      end
      return data
    end

    def transfer_section(data)
      section = nil
      sections = {}
      data.each() do |r|
        if r[0] =~ /\[(.*?)\]/
        section = $1
        sections[section] = [] unless sections.member?(section)
        else
        sections[section].push(r) unless section.nil?
        end
      end
      return sections
    end

    def create_properties_container(section)
      names = section['name'].flatten()
      types = section['type'].flatten()
      data = section['data']
      if section.member?('properties')
        props = section['properties'].flatten()
        names.each_index() do |i|
          prop = props[i]
          if prop.nil? or prop.empty?
            names[i] = nil
            types[i] = nil
          end
        end
      end
      keys = get_section_keys(section)
      con = {}
      data.each() do |values|
        _create_value(con,Hash.new,names,types,keys,values)
      end
      return con
    end

    def create_objects(section)
      if section.member?('instance_data')
        return create_object_single(section)
      else
        return create_object_container(section)
      end
    end

    def create_object_container(section)
      con = {}
      names = section['name'].flatten()
      types = section['type'].flatten()
      data = section['data']
      klass_names = section['class'].flatten()
      keys = get_section_keys(section)

      klass_names.each() do |klass_name|
        if klass_name == 'Array'
          array_names = section['array'].flatten()
          con[klass_name] = _create_array_container(data,array_names,types,['index'])
        else
          klass = eval(klass_name)
          con[klass_name] = {} unless con.member?(klass_name)
          data.each() do |values|
            _create_value(con[klass_name],klass.new,names,types,keys,values)
          end
        end
      end
      return con
    end

    def create_object_single(section)
      klass_name = section['class'].flatten()[0]
      klass = eval(klass_name)
      obj = klass.new
      data = section['instance_data']
      data.each() do |rec|
        kn,kt,val = rec
        next if val.nil?
        val.gsub!(/"/,'')
        next if val.empty?
        val = @value_creator.transfer(kn,kt,val)
        if obj.methods().include?("#{kn}=")
          # lݒ
          begin
            obj.send("#{kn}=",val)
          rescue
            p $!
          end
        end
      end
      return obj
    end

    private

    def _create_array_container(data,names,types,keys)
      result = {}
      data.each() do |values|
        _create_value(result,Hash.new,names,types,keys,values)
      end
      list = []
      result['index'].keys().sort().each() do |i|
        list[i] = result['index'][i]['value']
      end
      return list
    end

    def _value_normaliz(val)
      return nil if val.nil?
      if val != '""'
        val.gsub!(/"/,'')
      end
      return nil if val.empty?
      return val.gsub(/"/,'')
    end

    def _each_transfer(names,types,values,check_nil=true)
      names.each_index() do |i|
        val = _value_normaliz(values[i])
        kn = names[i]
        kt = types[i]
        if check_nil
          next if kn.nil? or kt.nil? or val.nil?
        end
        val = @value_creator.transfer(kn,kt,val) if not val.nil?
        yield(kn,kt,val)
      end
    end

    def _create_value(con,obj,names,types,keys,values)
      key_values = []
      _each_transfer(names,types,values) do |kn,kt,val|
        if obj.is_a?(Hash)
          obj[kn] = val
        elsif obj.methods().include?("#{kn}=")
          # lݒ
          begin
            obj.send("#{kn}=",val)
          rescue
            p $!
          end
        end
        if keys.member?(kn)
          key_values.push(val)
        end
      end
      keys.each_index() do |i|
        k1 = keys[i]
        k2 = key_values[i]
        con[k1] = {} unless con.member?(k1)
        con[k1][k2] = obj
      end
      return con
    end

    def _load_col_element(result,row)
      cells = []
      row.elements().each('table:table-cell') do |cell|
        node = cell.elements['text:p']
        text = ''
        if (not node.nil?) and (not node.text.nil?)
          if node.has_elements?
            text = node.texts().join('')
          else
          text = node.text
          end
        end
        cells.push(text)
        n = cell.attributes['number-columns-repeated'].to_i - 1
        n.times {cells.push(text)}
      end
      while (not cells.empty?()) and cells.last.empty?()
        cells.pop
      end
      if not cells.empty?()
      result.push(cells)
      end
    end

    def _load_row_element(result,t)
      t.elements().each('*') do |row|
        case row.name
        when 'table-row'
          _load_col_element(result,row)
        when 'table-row-group'
          _load_row_element(result,row)
        end
      end
    end

    def _load_table_element(t)
      result = []
      _load_row_element(result,t)
      return result
    end

  end

  class Default_Value_Creator
    def initialize(compiler)
      @compiler = compiler
    end

    def compiler
      @compiler
    end

    def transfer(kn,kt,val)
      if methods.include?("create_value_#{kt}")
        begin
          val = send("create_value_#{kt}",kn,kt,val)
        rescue
        end
      end
      return val
    end

    def create_value_strint(key_name,key_type,value)
      if value =~ /^[0-9]+$/
        create_value_int(key_name,key_type,value)
      else
        create_value_str(key_name,key_type,value)
      end
    end

    def create_value_str(key_name,key_type,value)
      value.to_s
    end

    def create_value_int(key_name,key_type,value)
      value.gsub(/,/,'').to_i
    end

    def create_value_bool(key_name,key_type,value)
      value == 'TRUE' or value == 'true'
    end

    def create_value_str_array(key_name,key_type,value)
      value.split(/\s+/).collect() {|v|v.to_s}
    end

    def create_value_int_array(key_name,key_type,value)
      value.split(/\s+/).collect() {|v|v.to_i}
    end

    # Table.new() l
    def create_value_table_array(key_name,key_type,value)
      value = value.split(/\s+/).collect() {|v|v.to_i}
      t = Table.new(value.size)
      value.each_index() do |i|
        t[i] = value[i]
      end
      t
    end

    def create_value_sheet_ref(key_name,key_type,value)
      value,type = value.split(/:/)
      r = self.compiler.load_fods(value)
      r = self.compiler.remove_comment(r)
      s = self.compiler.transfer_section(r)
      o = self.compiler.create_objects(s)
      if not o.is_a?(Hash)
      return o
      end
      if type.nil?
      return o.values[0]
      end
      return o[type]
    end
  end
end
