require 'debug/rpgxpdt_log.rb'
require 'debug/rgss_base.rb'
require 'tools/dbc/data_compiler.rb'

def database_compile(project_dir)
  Debug.log("database_compile(#{project_dir})") if $DEBUG
  current_dir = Dir.pwd
  begin
    Dir.chdir(project_dir)
    Debug.log("Dir.chdir(#{project_dir})") if $DEBUG
    dc = Data_Compiler.new
    dc.compile(::RPG::State,'States')
    dc.compile(::RPG::Class,'Classes')
    dc.compile(::RPG::Skill,'Skills')
    dc.compile(::RPG::Item,'Items')
    dc.compile(::RPG::Weapon,'Weapons')
    dc.compile(::RPG::Armor,'Armors')
    dc.compile(::RPG::Enemy,'Enemies')
    dc.compile(::RPG::Actor,'Actors')
    dc.setup_weapon_equip_data
    dc.setup_armor_equip_data
    dc.setup_skill_learnings_data
  rescue => evar
    p $!
    p evar
  end
  Dir.chdir(current_dir)
  Debug.log("Dir.chdir(#{current_dir})") if $DEBUG
end

def install_file_update?(file1,file2)
  return false unless FileTest.exist?(file1)
  return true unless FileTest.exist?(file2)
  t1 = File.mtime(file1)
  t2 = File.mtime(file2)
  return t1 > t2
end

def install_file(form_filename,to_filename)
  if FileTest.directory?(File.dirname(to_filename))
    if install_file_update?(form_filename,to_filename)
      FileUtils.move(form_filename, to_filename)
      Debug.log("move #{form_filename} #{to_filename}") if $DEBUG
    end
  end
end
