module Move_Route_Util
  IMPORT = 0
  EXPORT = 1

  DATA = {
    0 => [%W()],
    1  => [%W(Ɉړ)],
    2  => [%W(Ɉړ)],
    3  => [%W(EɈړ)],
    4  => [%W(Ɉړ)],
    5  => [%W(Ɉړ)],
    6  => [%W(EɈړ)],
    7  => [%W(Ɉړ)],
    8  => [%W(EɈړ)],
    9  => [%W(_Ɉړ)],
    10 => [%W(vC[ɋ߂Â)],
    11 => [%W(vC[牓)],
    12 => [%W(Oi)],
    13 => [%W()],
    14 => [%W(Wv),0,0],
    15 => [%W(EFCg),0],
    16 => [%W()],
    17 => [%W()],
    18 => [%W(E)],
    19 => [%W()],
    20 => [%W(E90x] EɂXOx])],
    21 => [%W(90x] ɂXOx])],
    22 => [%W(180x] PWOx]A)],
    23 => [%W(E90x] EɂXOx])],
    24 => [%W(_ɕ])],
    25 => [%W(vC[̕)],
    26 => [%W(vC[̋t)],
    27 => [%W(XCb`ON),proc do |flag,values|
      if flag == EXPORT
        return values.collect() {|v| Event_Compiler_Util.switch_name(v)}
      else
        return values.collect() {|v| Event_Compiler_Util.switch_id(v)}
      end
    end],
    28 => [%W(XCb`OFF),proc do |flag,values|
      if flag == EXPORT
        return values.collect() {|v| Event_Compiler_Util.switch_name(v)}
      else
        return values.collect() {|v| Event_Compiler_Util.switch_id(v)}
      end
    end],
    29 => [%W(ړx̕ύX),0],
    30 => [%W(ړpx̕ύX),0],
    31 => [%W(ړAjON)],
    32 => [%W(ړAjOFF)],
    33 => [%W(~AjON)],
    34 => [%W(~AjOFF)],
    35 => [%W(ŒON)],
    36 => [%W(ŒOFF)],
    37 => [%W(蔲ON)],
    38 => [%W(蔲OFF)],
    39 => [%W(őOʂɕ\\ON)],
    40 => [%W(őOʂɕ\\OFF)],
    41 => [%W(OtBbNύX),proc do |flag,values|
      if flag == EXPORT
        (name,hue,direction,pattern) = values
        direction = Event_Compiler_Util.direction_name(direction)
      else
        name = ""
        hue = 0
        direction = 2
        pattern = 0
        name = values[0].to_s if values.size >= 1
        hue = values[1].to_i if values.size >= 2
        if values.size >= 3
          direction = Event_Compiler_Util.parse_direction(values[2])
        end
        pattern = values[3].to_i if values.size >= 4
      end
      return [name,hue,direction,pattern]
    end],
    42 => [%W(sx̕ύX),0],
    43 => [%W(@̕ύX),proc do |flag,values|
      blend_type = 0
      if flag == EXPORT
        blend_type = Event_Compiler_Util.blend_type_name(values[0])
      else
        unless values.empty?
          blend_type = Event_Compiler_Util.blend_type(values[0])
        end
      end
      return [blend_type]
    end],
    44 => [%W(SẺt SE),proc do |flag,values|
      if flag == EXPORT
        se = values[0]
        return [se.name,se.volume,se.pitch]
      else
        se = RPG::AudioFile.new()
        unless values.empty?
          se.name = values[0].to_s if values.size >= 1
          se.volume = values[1].to_i if values.size >= 2
          se.pitch = values[2].to_i if values.size >= 3
        end
        return [se]
      end
    end],
    45 => [%W(XNvg),'']
  }
  
  NAMES = DATA.inject({}) do |r,o|
    r[o[0]] = o[1][0][0];r
  end

  CODE = DATA.inject({}) do |r,o|
    o[1][0].inject(r) do |r,vv|
      r[vv] = o[0];r
    end
  end
  
  PARAM_TYPES = DATA.inject({}) do |r,o|
    r[o[0]] = o[1][1 .. -1];r
  end
  

  module_function
  
  def create_move_command(line)
    (name,*params) = line.split(/F|:|A|,/)
    code = CODE[name]
    cmd = RPG::MoveCommand.new(code)
    PARAM_TYPES[code].zip(params) do |param_type,value|
      case param_type
      when Integer,String
        cmd.parameters.push(value)
      when Proc
        cmd.parameters = param_type.call(IMPORT,params)
      end
    end
    return cmd 
  end
  
  def create_move_route(line)
    move_route = RPG::MoveRoute.new
    if line =~ /#{Regexp.escape('JԂ')}/
      move_route.repeat = true
    else
      move_route.repeat = false
    end
    if line =~ /#{Regexp.escape('ړłȂꍇ͖')}/
      move_route.skippable = true
    else
      move_route.skippable = false
    end
    move_route.list = []
    return move_route
  end
  
  def import(_lines=[])
    lines = _lines.dup
    move_route = create_move_route(lines.shift)
    lines.each() do |line|
      cmd = create_move_command(line)
      move_route.list.push(cmd)
    end
    return move_route
  end
  def export_move_route_params(move_route)
    params = []
    if move_route.repeat
      params.push 'JԂ'
    else
      params.push 'JԂȂ'
    end
    params.push 'ړłȂꍇ͖' if move_route.skippable
    return params
  end
  def export_move_command(move_command)
    out = ""
    out << NAMES[move_command.code]
    unless move_command.parameters.empty?
      param_types = PARAM_TYPES[move_command.code]
      params = []
      param_types.zip(move_command.parameters) do |param_type,value|
        case param_type
        when Integer,String
          params.push(value)
        when Proc
          params = param_type.call(EXPORT,move_command.parameters)
        end
      end
      out << 'F' << params.join(',')
    end
    return out
  end
  def export(move_route)
    name = 'ړ[g̐ݒF'
    params = export_move_route_params(move_route)
    out = name + params.join(',')
    out << "\n"
    list = move_route.list
    list.each() do |move_command|
      out << export_move_command(move_command)
      out << "\n"
    end
    return out
  end
end
