# Ring ノートパットアプリケーション (RNote)
# 原作者 : Mahmoud Fayed <msfclipper@yahoo.com>

class RNoteTreeViewEvents

	func CheckSaveBeforeChange
		if cActiveFileName = NULL return ok
		SaveSettings()

	func ChangeFile
		CheckSaveBeforeChange()	# ファイルの保存をユーザに問い合わせる
		SaveCurrentFolder()
		oItem = tree1.currentindex()
		if ofile.isdir(oItem)
			return
		ok
		# 旧ファイルの保存 
			cOldActiveFileName = cActiveFileName
		# フォームデザイナーを開く 
		lActivateFormDesigner = False
		if right(ofile.filepath(oItem),6) = ".rform"
			StatusMessage("ファイルから開く...")
			if ofile.filepath(oItem) != cFormFile 
				cFormFile = ofile.filepath(oItem)
				FormDesigner().OpenFile(ofile.filepath(oItem))
			ok
			StatusMessage("準備完了！")
			oDockFormDesigner.raise()
			cSourceFile = substr(cFormFile,".rform","Controller.ring")
			if fexists(FileNameEncoding(cSourceFile))
				cActiveFileName = cSourceFile
			else 
				return 
			ok
			lActivateFormDesigner = True
		else 
			cActiveFileName = ofile.filepath(oItem)
		ok
		# aFilesLines 以前の更新で textedit1.settext() で値を取得する前に nLine を得ます。
			nLine =  aFilesLines[cActiveFileName]
		try 
			textedit1.setPlaintext(read(FileNameEncoding(cActiveFileName)))
		catch 
			msginfo("もうしわけございません","ファイルを開けません " + cActiveFileName)
			cActiveFileName = cOldActiveFileName
			return 
		end 
		textedit1.setfocus(0)
		CursorPositionChanged()
		SetActiveFileName()
		if nLine != NULL
			gotoline(nLine)
		ok
		AutoComplete()
		lAsktoSave = False
		cTextHash  = sha256(textedit1.toplaintext())
		oDockFunctionsList.setWindowTitle("関数 (読み込み中...)")
		oDockClassesList.setWindowTitle("クラス (読み込み中...)")
		DisplayFunctionsList()
		DisplayClassesList()
		if lActivateFormDesigner
			oDockFormDesigner.raise()
		else 
			oDockSourceCode.raise()
			tree1.setFocus(0)
		ok
		StatusMessage("準備完了！")
