﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace SerialEx
{
    public partial class Form1 : Form
    {
        URG port = new URG();
        public Form1()
        {
            InitializeComponent();
            port.portOpen("COM5");
            port.Recieved += new URG.DataRecievedHandler(this.writeRichText);//センサ返信が来たイベントが発生したら呼び出すスレッドの登録
        }

        private void button1_Click(object sender, EventArgs e)
        {
            String data;
            data = "MD0044072501001\n";
            //data = "VV\n";
            port.sendCmd(data);

        }

        private void writeRichText(string message)
        {
            RecievedDataDelegate add = new RecievedDataDelegate(addRichText);
            this.richTextBox1.Invoke(add, message);
        }
        private delegate void RecievedDataDelegate(string data);
        private void addRichText(string recievedData)
        {
            this.richTextBox1.Text = recievedData;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            port.sendCmd("QT\n");
            //port.portClose();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            port.setPropaty();
        }

    }


    public class URG
    {

        public delegate void DataRecievedHandler(string data);
        public event DataRecievedHandler Recieved; //センサから返信を受けたら発生するRecievedイベントハンドラ

        private System.IO.Ports.SerialPort serialPort1 = new System.IO.Ports.SerialPort();//シリアルポートの追加

        public void portOpen(string portNo)
        {
            this.serialPort1.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(serialPort1_DataReceived);//シリアル通信から受信したときのイベントハンドラ
            this.serialPort1.PortName = portNo;
            this.serialPort1.BaudRate = 19200;
            this.serialPort1.Parity = System.IO.Ports.Parity.None;
            this.serialPort1.DataBits = 8;
            this.serialPort1.StopBits = System.IO.Ports.StopBits.One;
            this.serialPort1.Open();
            this.sendCmd("SCIP2.0\n");//起動モードをSCIP1.0から2.0に変更．これがないと，返り値が「E」とだけ出て動かない．
        }
        public void portClose()
        {
            this.serialPort1.Close();
        }

        public void setPropaty()
        {
            propatyForm propaty = new propatyForm();
            propaty.ShowDialog();


            propaty.Dispose();
        }

        public void sendCmd(String cmd)
        {
            this.serialPort1.WriteLine(cmd);
        }


        private void serialPort1_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)//シリアル通信に受信があると呼ばれるメソッド
        {
            string receivedData;

            try
            {
                receivedData = this.Decode(this.serialPort1.ReadExisting());//シリアルポートから受信内容を取り出す

            }
            catch (Exception ex)
            {
                receivedData = ex.Message;
            }

            notify(receivedData);

        }

        protected virtual void notify(string message)//ポートからセンサの返信を受け取ったことを示すRecievedイベントを発行するメソッド
        {
            if (Recieved != null)
            {
                Recieved(message);
            }

        }

        private string Decode(string receivedData)
        {
            string[] delimiter = {this.serialPort1.NewLine}; 
            string[] parts = receivedData.Split(delimiter, StringSplitOptions.RemoveEmptyEntries);
            string   d = String.Empty;
            string   r = String.Empty;

            if (parts.Length > 3)
            {
                for (int i = 3; i < parts.Length; i++)
                {
                    parts[i] = parts[i].Remove(parts[i].Length-1,1);
                    r += parts[i];

                }

                //int ch = 44;
                for (int k = 0; k < r.Length; k += 3)
                {
                    string s = String.Empty;

                    int x = r[k] - 0x30;
                    string t = Convert.ToString(x, 2);
                    s += t.PadLeft(6, '0');

                    x = r[k + 1] - 0x30;
                    t = Convert.ToString(x, 2);
                    s += t.PadLeft(6, '0');
                    
                    x = r[k + 2] - 0x30;
                    t = Convert.ToString(x, 2);
                    s += t.PadLeft(6, '0');

                    x = Convert.ToInt32(s, 2); //
                    if (x < 19)                //距離データが19以下ならエラーとして0に
                        x = 0;                 //
                    
                    //d += "[" + ch++ + "]";     //デコードテスト用，ステップ番号添付
                    d += x + "\r";
                }

                //string[] dsitance = d.Split(delimiter, StringSplitOptions.RemoveEmptyEntries);

                return d;
            }
            else
            {
                return receivedData;
            }


        }
    }

    public class propatyForm : Form
    {
        GroupBox gb = new GroupBox();
        RadioButton md = new RadioButton();
        RadioButton gd = new RadioButton();
        RadioButton ms = new RadioButton();
        RadioButton gs = new RadioButton();

        public propatyForm()
        {
            this.Size = new Size(300, 480);
            this.Text = "測域範囲設定";

            Button OKbutton = new Button();
            OKbutton.Location = new Point(200, 400);
            OKbutton.Text = "OK";
            OKbutton.Name = "OKbutton";

            gb.Text = "コマンド選択";
            gb.Location = new Point(20, 20);
            gb.Width = md.Width * 2 + 10;
            gb.Height = md.Height * 2 + 30;
             
            md.Text = "MD";
            md.Location = new Point(gb.Location.X+10, gb.Location.Y+5);
            md.AutoSize = true;
            md.Checked = true;
            //md.Click += new EventHandler(RBCheck);


            gd.Text = "GD";
            gd.Location = new Point(gb.Location.X+10, md.Location.Y+md.Height);
            gd.AutoSize = true;


            ms.Text = "MS";
            ms.Location = new Point(10 + md.Width, gb.Location.Y+5);
            ms.AutoSize = true;


            gs.Text = "GS";
            gs.Location = new Point(10 + md.Width, md.Location.Y + md.Height);
            gs.AutoSize = true;

            Label range = new Label();
            range.Location = new Point(20, 120);
            range.Text = "測定範囲";

            Label matome = new Label();
            matome.Location = new Point(20, 170);
            matome.Text = "まとめ回数";

            Label syuuki = new Label();
            syuuki.Location = new Point(20, 220);
            syuuki.Text = "測定周期";

            Label number = new Label();
            number.Location = new Point(20, 270);
            number.Text = "測定回数";

            this.Controls.Add(OKbutton);
            this.Controls.Add(gb);
            gb.Controls.Add(md);
            gb.Controls.Add(ms);
            gb.Controls.Add(gd);
            gb.Controls.Add(gs);
            this.Controls.Add(range);
            this.Controls.Add(matome);
            this.Controls.Add(syuuki);
            this.Controls.Add(number);
        }

    }



}
