//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__dx10__buffer_HPP__
#define __SFJP_ROAST_EX__graphics__directx__dx10__buffer_HPP__

#include "roast/graphics/directx/dx10/device.hpp"
#include "roast/graphics/directx/shader_param.hpp"	//	Hmm...

namespace roast
{
	namespace directx
	{
		namespace dx10
		{
			namespace graphics
			{
				///////////////////////////////////////////////////////////////////////////

				class buffer : /*public buffer_base,*/ protected iunknown_<d3dbuffer>
				{
				public:
					typedef d3dbuffer _BufferT, _IfType;
					enum exception_codes
					{
						exception_codes__head = exception_code_root::buffer,

						buffer__CreateBuffer_Failed
					};
				protected:
					device& m_dev;

				public:
					buffer(device &d, D3D10_BIND_FLAG buffer_type, unsigned int size, const void* initial_data=NULL,
						::D3D10_USAGE access=D3D10_USAGE_DEFAULT, UINT cpu_access=0,
						UINT memory_pitch=0, UINT slice_pitch=0, UINT misc_flags=0) : m_dev(d)
					{
						::D3D10_BUFFER_DESC bufdesc;
						//::ZeroMemory( &bufdesc, sizeof(bufdesc) );
						bufdesc.BindFlags = buffer_type;
						bufdesc.ByteWidth = size;
						bufdesc.Usage = access;
						bufdesc.CPUAccessFlags = (D3D10_CPU_ACCESS_FLAG)cpu_access;
						bufdesc.MiscFlags = misc_flags;

						::D3D10_SUBRESOURCE_DATA srdata;
						srdata.pSysMem = initial_data;
						srdata.SysMemPitch = memory_pitch;
						srdata.SysMemSlicePitch = slice_pitch;

						::HRESULT hr = m_dev.get_id3d_device_ptr()->CreateBuffer( &bufdesc, &srdata, &m_if );
						if ( hr != D3D_OK ){
							throw api_error(buffer__CreateBuffer_Failed,
								"ID3D10Device::CreateBuffer() Failed.", hr);
						}
					}

					///////////////

					
					//////////////////////////////////////////////////////////////////////////////
					
					_BufferT* get_buffer_ptr(){ return get_internal_ptr(); }
					const _BufferT* get_buffer_ptr() const { return get_internal_ptr(); }
				};

				///////////////////////////////////////////////////////////////////////////

				template <typename VERTEX_TYPE>
				class input_vertex_buffer : public buffer
				{
				public:
					input_vertex_buffer(device &d, const VERTEX_TYPE* initial_data, unsigned int size) : buffer(d,D3D10_BIND_VERTEX_BUFFER,size,initial_data){}
				};

				///////////////////////////////////////////////////////////////////////////
			}
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__dx10__buffer_HPP__
