//	Roast+ License

#ifndef __SFJP_ROAST_EX__windows__control_HPP__
#define __SFJP_ROAST_EX__windows__control_HPP__

#include <windows.h>
#include <string>
#include <map>

namespace roast
{
	namespace windows
	{
		typedef ::LPCTSTR lpctstr_t;

		//////

		class windows_exception : public ::std::string
		{
		public:
			windows_exception(const char* s) : ::std::string(s) {}
			windows_exception(const ::std::string& s) : ::std::string(s) {}
		};

		class windows_control_exception : public windows_exception
		{
		public:
			windows_control_exception(const char* s) : windows_exception(s) {}
			windows_control_exception(const ::std::string& s) : windows_exception(s) {}
		};
		
		/////////////////////////////////////////////////////////////////////////////////////////

		template <typename _BaseWndClass=::WNDCLASSEX>
		struct window_class_ : protected _BaseWndClass
		{
		private:
			typedef _BaseWndClass _Base;
		public:
			window_class_(lpctstr_t szClassName, HINSTANCE hInstance, WNDPROC lpfnWndProc,
				UINT uiClassStyle=0)
			{
				this->cbSize		= sizeof(_BaseWndClass);
				this->style			= uiClassStyle;
				this->lpfnWndProc	= lpfnWndProc;
				this->hInstance		= hInstance;
				this->cbClsExtra	= 0;	//	sizeof(_BaseWndClass) - sizeof(WNDCLASSEX)?
				this->cbWndExtra	= 0;
				this->hIcon			= NULL;
				this->hCursor		= NULL;
				this->hbrBackground	= NULL;
				this->lpszMenuName	= NULL;
				this->lpszClassName	= szClassName;
				this->hIconSm		= NULL;
			}
			
			////////////
			
			void set_class_style(UINT uiClassStyle){ this->style = uiClassStyle; }
			//void set_style(UINT style){ this->cbSize = style; }
			void set_icon(HICON hIcon, HICON hSmallIcon=NULL){
				this->hIcon = hIcon;
				if ( hSmallIcon )
					this->hIconSm = hSmallIcon;
			}
			void set_cursor(HCURSOR hCursor){ this->hCursor = hCursor; }
			void set_background_brush(HBRUSH hbrBackground){ this->hbrBackground = hbrBackground; }
			void set_menu(lpctstr_t lpszMenuName){ this->lpszMenuName = lpszMenuName; }
			
			////////////
			
			lpctstr_t get_class_name() const { return this->lpszClassName; }
			HINSTANCE get_hinstance() const { return this->hInstance; }
			_BaseWndClass* get_wndclass_ptr() const { return (_BaseWndClass*)this; }
		};
		typedef window_class_<> window_class;
		
		///////

		template <typename T>
		unsigned int regist_window_class(const window_class_<T>& wc){	//	OK is not zero, NG is zero.
			return ::RegisterClassEx( wc.get_wndclass_ptr() );
		}
		
		inline bool unregist_window_class(lpctstr_t class_name, HINSTANCE hAppInstance){
			return ( ::UnregisterClass(class_name, hAppInstance) != FALSE );
		}
		template <typename T>
		bool unregist_window_class(const window_class_<T>& wc, HINSTANCE hAppInstance=NULL){	//	hAppInstance=NULL by wc.hInstance
			if ( hAppInstance == NULL )
				hAppInstance = wc.get_hinstance();
			return unregist_window_class(wc.get_class_name(), hAppInstance);
		}
		
		///////
		
		class auto_window_class
		{
		private:
			window_class m_wc;
			HINSTANCE m_hAppInstance;
		public:
			auto_window_class(const window_class& wc, HINSTANCE hAppInstance=NULL)	//	hAppInstance=NULL by wc.hInstance
				 : m_wc(wc), m_hAppInstance(hAppInstance)
			{
				regist_window_class(m_wc);
			}
			virtual ~auto_window_class()
			{
				unregist_window_class(m_wc, m_hAppInstance);
			}
		};
		
		/////////////////////////////////////////////////////////////////////////////////////////
		
		class control
		{
		protected:
			HWND m_hWnd;
			HINSTANCE m_hAppInstance;
			lpctstr_t m_szClassName;
			//DWORD m_dwPreCreateStyle;
			//int m_nPreCreateShowWindow;

		public:
			struct standard_class
			{
				static const char* button;// = "BUTTON";
				static const char* edit_box;// = "EDIT";
				static const char* list_box;// = "LISTBOX";
				static const char* combo_box;// = "COMBOBOX";
				static const char* label;// = "STATIC";
				static const char* scroll_bar;// = "SCROLLBAR";
				static const char* mdi_client;// = "MDICLIENT";
				static const char* rich_edit;// = "RICHEDIT_CLASS";
			};
			typedef standard_class preset_class, std_class, default_class;
			//static const struct preset_class_ preset_class;

		public:
			control(lpctstr_t szWindowClassName)
				: m_szClassName(szWindowClassName)
			{
				m_hWnd = NULL;
				m_hAppInstance = NULL;
				//m_dwPreCreateStyle = 0;
				//m_nPreCreateShowWindow = 0;
			}
			
			bool start(
				int nWidth,						//	Control / Window Width
				int nHeight,					//	Control / Window Height
				lpctstr_t lpControlText,		//	Control / Window Title
				HWND hWndParent=NULL,			//	Parent Control / Window Handle, Desktop / Not Child Window is NULL.
				int nPositionX=CW_USEDEFAULT,	//	Control / Window Position X
				int nPositionY=CW_USEDEFAULT,	//	Control / Window Position Y
				DWORD dwStyle=0,				//	Control / Window Styles. (WS_* bit flags)
				DWORD dwExStyle=0,				//	Control / Window Ex Styles. (WS_EX_* bit flags)
				int nShowWindow=SW_SHOWNORMAL,
				LPVOID lpParam=NULL,		    //	Paramator
				HMENU hMenu=NULL,				//	Menu Handle
				HINSTANCE hInstance=NULL		//	Application Instance Handle (Windows 2000 later is NULL)
			)
			{
				//nShowWindow |= m_nPreCreateShowWindow;
				//dwStyle |= m_dwPreCreateStyle;

				m_hAppInstance = hInstance;
				m_hWnd = ::CreateWindowEx(dwExStyle, m_szClassName,lpControlText,dwStyle,nPositionX,nPositionY,nWidth,nHeight,
					hWndParent,hMenu,hInstance,lpParam);

				if ( m_hWnd == NULL )
				{
					DWORD dwLastError = ::GetLastError();
					switch(dwLastError)
					{
					//	if GetLastError() was 0, maybe Window Class Callback Function WM_NCCREATE returned FALSE,
					//	or WM_CREATE returned -1 ( on_create() returned false) .
					/*case 0:
						throw windows_control_exception(::std::string("ClassName \"") + m_szClassName + "\" is Unknown.");*/
					case ERROR_CANNOT_FIND_WND_CLASS:
#ifdef UNICODE
						throw windows_control_exception("ClassName is Unknown.");
#else
						throw windows_control_exception(::std::string("ClassName \"") + m_szClassName + "\" is Unknown.");
#endif
					}
					return false;
				}
				
				//::ShowWindow( m_hWnd, SW_SHOW );
				::UpdateWindow( m_hWnd );
				::ShowWindow( m_hWnd, nShowWindow );

				return true;
			}
			
			bool set_text(lpctstr_t text){ return ( ::SetWindowText(m_hWnd, text) == TRUE ); }

			::HWND get_hwnd() const { return m_hWnd; }
			::HWND get_window_handle() const { return m_hWnd; }
			::RECT get_rect() const { ::RECT rect; ::GetWindowRect(m_hWnd,&rect); return rect; }
			unsigned int get_width() const { ::RECT rect = get_rect(); return rect.right - rect.left; }
			unsigned int get_height() const { ::RECT rect = get_rect(); return rect.bottom - rect.top; }
		
			////////////////////////////////

			void enable(bool bEnable=true){ ::EnableWindow(m_hWnd, (bEnable ? TRUE : FALSE) ); }
			void disable(){ enable(false); }
			void show(bool bShow=true){ ::ShowWindow( m_hWnd, (bShow ? SW_SHOWNORMAL : SW_HIDE) ); }
			void hide(){ return show(false); }
			//bool show_window(bool bShow=true){}
			//bool hide_window(){ return show_window(false); }
			void set_focus(){ ::SetFocus(m_hWnd); }
		};

		//
		const char* control::standard_class::button = "BUTTON";
		const char* control::standard_class::edit_box = "EDIT";
		const char* control::standard_class::list_box = "LISTBOX";
		const char* control::standard_class::combo_box = "COMBOBOX";
		const char* control::standard_class::label = "STATIC";
		const char* control::standard_class::scroll_bar = "SCROLLBAR";
		const char* control::standard_class::mdi_client = "MDICLIENT";
		const char* control::standard_class::rich_edit = "RICHEDIT_CLASS";

		/////

		class std_control : public control
		{
		private:
			typedef control _Base;
		protected:
			bool m_enable;
			bool m_show;
		public:
			//control_property()
			std_control(lpctstr_t szWindowClassName)
				: _Base(szWindowClassName)
			{
				m_enable = true;
				m_show = true;
			}

			void enable(bool is_enable=true){ m_enable = is_enable; if(m_hWnd){ _Base::enable(is_enable); } }
			void disable(){ enable(false); }
			void show(bool is_show=true){ m_show = is_show; if(m_hWnd){ _Base::show(is_show); } }
			void hide(){ return show(false); }
		};

		/////////////////////////////////////////////////////////////////////////////////////////

		class message_callback_base
		{
		public:
			static ::std::map<HWND, message_callback_base*> m_hwnd2this_map;
			void regist_in_hwnd(HWND hWnd){ m_hwnd2this_map[hWnd] = this; }

		protected:
			//HWND m_hWnd;

			static const int sizing_hold_bit_left = 1;
			static const int sizing_hold_bit_top = 2;
			static const int sizing_hold_bit_right = 4;
			static const int sizing_hold_bit_bottom = 8;

			bool is_sizing_hold_left(unsigned int hold_bitflg){ return !(!( hold_bitflg & sizing_hold_bit_left )); }
			bool is_sizing_hold_top(unsigned int hold_bitflg){ return !(!( hold_bitflg & sizing_hold_bit_top )); }
			bool is_sizing_hold_right(unsigned int hold_bitflg){ return !(!( hold_bitflg & sizing_hold_bit_right )); }
			bool is_sizing_hold_bottom(unsigned int hold_bitflg){ return !(!( hold_bitflg & sizing_hold_bit_bottom )); }

			virtual bool on_close(){ return true; }
			virtual bool on_create(::LPCREATESTRUCT lpCreateStruct){ return true; } // If returns false, the window is destroyed and the control::start() returns false.
			virtual void on_destroy(){ ::PostQuitMessage( 0 ); }
			virtual void on_move(unsigned short x, unsigned short y){}
			virtual void on_sizing(unsigned int hold_bitflg, const LPRECT lpControlRect){}

		private:
			LRESULT callback_main(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
			{
				//m_hWnd = hWnd;

				switch( msg )
				{
				case WM_CLOSE:	
					if ( on_close() )
						::DestroyWindow(hWnd);
					return 0;

				case WM_CREATE:	
					return ( on_create((::LPCREATESTRUCT)lParam) ? 0 : -1 );

				case WM_DESTROY:
					on_destroy();
					return 0;

				case WM_MOVE:
					on_move(LOWORD(lParam), HIWORD(lParam));
					return 0;

				case WM_SIZING:
					switch(wParam)
					{
					case WMSZ_LEFT:
						on_sizing(sizing_hold_bit_left, (const LPRECT)lParam);
						break;
					case WMSZ_RIGHT:
						on_sizing(sizing_hold_bit_right, (const LPRECT)lParam);
						break;
					case WMSZ_TOP:
						on_sizing(sizing_hold_bit_top, (const LPRECT)lParam);
						break;
					case WMSZ_BOTTOM:
						on_sizing(sizing_hold_bit_bottom, (const LPRECT)lParam);
						break;
						
					case WMSZ_TOPLEFT:
						on_sizing(sizing_hold_bit_top | sizing_hold_bit_left, (const LPRECT)lParam);
						break;
					case WMSZ_TOPRIGHT:
						on_sizing(sizing_hold_bit_top | sizing_hold_bit_right, (const LPRECT)lParam);
						break;
					case WMSZ_BOTTOMLEFT:
						on_sizing(sizing_hold_bit_bottom | sizing_hold_bit_left, (const LPRECT)lParam);
						break;
					case WMSZ_BOTTOMRIGHT:
						on_sizing(sizing_hold_bit_bottom | sizing_hold_bit_right, (const LPRECT)lParam);
						break;
					}
					return TRUE;
				}

				return ::DefWindowProc( hWnd, msg, wParam, lParam );
			}

		public:
			template <typename T>
			static LRESULT CALLBACK message_callback_static(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
			{
				::std::map<HWND, message_callback_base*>::iterator it = m_hwnd2this_map.find(hWnd);
				if ( it == m_hwnd2this_map.end() )
					return ::DefWindowProc( hWnd, msg, wParam, lParam );
				else
					return it->second->callback_main(hWnd, msg, wParam, lParam);
			}
		};

		::std::map<HWND, message_callback_base*> message_callback_base::m_hwnd2this_map;

		/////////////////////////////////////////////////////////////////////////////////////////
		
		class user_class_control : public control, public message_callback_base
		{
		public:
			user_class_control(lpctstr_t szWindowClassName) : control(szWindowClassName) {}
		};
		typedef user_class_control custom_class_control, user_control, custom_control;

		/////////////////////////////////////////////////////////////////////////////////////////
	}
}

#endif//__SFJP_ROAST_EX__windows__control_HPP__
