//	Roast+ License

#ifndef __SFJP_ROAST_EX__windows__fileutil_HPP__
#define __SFJP_ROAST_EX__windows__fileutil_HPP__

namespace roast
{
	namespace windows
	{
		class file_exception : public windows_exception
		{
		public:
			file_exception(const char* s) : windows_exception(s) {}
			file_exception(const ::std::string& s) : windows_exception(s) {}
		};

		////////////////////////////////////////////////////////
		
		::std::string get_module_filepath(::HINSTANCE hInstance=NULL) /* hInstance = NULL is Current Process Module Handle */
		{
			size_t bufsize = 256;
			for(;;)
			{
				::std::string s(bufsize, 0);
				DWORD dwCopiedLen = ::GetModuleFileName(NULL, (LPSTR)s.data(), bufsize);
				if ( dwCopiedLen == bufsize-1 ){
					bufsize *= 2;
					continue;
				}
				else
					return s;
			}
		}
		::std::string get_module_dir(::HINSTANCE hInstance=NULL) /* hInstance = NULL is Current Process Module Handle */
		{
			::std::string s = get_module_filepath(hInstance);
			/*
			char *p = strrchr((char*)s.data(), '\\');
			if ( p == NULL )
				return "";
			*(p+1) = '\0';
			*/
			extract_dirpath(s);
			return s;
		}
		::std::string get_current_module_filepath(){ return get_module_filepath(); }
		::std::string get_current_module_dir(){ return get_module_dir(); }

	}
}

#endif//__SFJP_ROAST_EX__windows__fileutil_HPP__
