//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__bases_HPP__
#define __SFJP_ROAST_EX__graphics__directx__bases_HPP__

#include "roast/windows/window.hpp"

namespace roast
{
	namespace directx
	{
		namespace graphics
		{
			///////////////////////////////////////////////////////
			
			class d3dcaps_impl_base
			{
			};
			
			class d3dcaps
			{
			protected:
				d3dcaps_impl_base* m_impl;
			public:
				d3dcaps(){ m_impl = NULL; }
				template <typename _Impl>
				d3dcaps(_Impl& impl){ m_impl = new _Impl(impl); }
				virtual ~d3dcaps(){ if(m_impl) delete m_impl; }
			};

			class disp_mode
			{
			protected:
				UINT Width;
				UINT Height;
				UINT RefreshRate;
				UINT Format;
			public:
				disp_mode(){
					Width = 0;
					Height = 0;
					RefreshRate = 0;
					Format = 0;
				}
				void set_width(UINT Width_in){ Width = Width_in; }
				void set_height(UINT Height_in){ Height = Height_in; }
				void set_refresh_rate(UINT RefreshRate_in){ RefreshRate = RefreshRate_in; }
				void set_format(UINT Format_in){ Format = Format_in; }

				UINT get_width(){ return Width; }
				UINT get_height(){ return Height; }
				UINT get_refresh_rate(){ return RefreshRate; }
				UINT get_format(){ return Format; }
			};

			//////

			class first_base
			{
			public:
				/*virtual d3dcaps get_device_caps(UINT AdapterNo, D3DDEVTYPE DeviceType)=0;
				d3dcaps get_caps(UINT AdapterNo, D3DDEVTYPE DeviceType){ return get_device_caps(AdapterNo, DeviceType); }

				bool test_device(UINT AdapterNo, D3DDEVTYPE DeviceType){
					try
					{
						get_device_caps(AdapterNo, DeviceType);
					}
					catch(const api_error &){
						return false;
					}
					return true;
				}

				virtual disp_mode get_current_display_mode(UINT AdapterNo=0)=0;*/
			};
			
			//////
			
			class device_base
			{
			public:
				virtual void start(
					const ::roast::windows::window &w,
					bool fullscreen=false,
					int adapter_no=0)=0;
				virtual void clear(const color_t& cl=colordef::black)=0;
				virtual void present()=0;
			};
			
			//////
			
			class effect_base
			{
			public:
				typedef ::std::map<::std::string,::std::string> defines_t;
			};
			
			///////////////////////////////////////////////////////
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__bases_HPP__
