//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__color_HPP__
#define __SFJP_ROAST_EX__graphics__directx__color_HPP__

#include <windows.h>
#include <string>

namespace roast
{
	namespace directx
	{
		namespace graphics
		{
			typedef ::D3DCOLOR color_t;
			
			namespace colordef
			{
				enum
				{
					black = 0x00000000,
					blue = 0x000000ff,
					white = 0x00ffffff
				};
			}

#define ROAST_HEXCOLOR_ARGB(ALPHA,RED,GREEN,BLUE)	D3DCOLOR_ARGB(ALPHA,RED,GREEN,BLUE)
#define ROAST_HEXCOLOR_XRGB(RED,GREEN,BLUE)			D3DCOLOR_XRGB(RED,GREEN,BLUE)

#define ROAST_HEXCOLOR_A(a)				((color_t)((((a)&0xff)<<24)|(0x00ffffff)))
#define ROAST_HEXCOLORW_A(a)			ROAST_HEXCOLOR_A(AghWrapByte(a))
#define ROAST_HEXCOLORW_ARGB(a,r,g,b)	ROAST_HEXCOLOR_ARGB(AghWrapByte(a),AghWrapByte(r),AghWrapByte(g),AghWrapByte(b))
#define ROAST_HEXCOLORW_RGBA(r,g,b,a)	ROAST_HEXCOLOR_RGBA(AghWrapByte(r),AghWrapByte(g),AghWrapByte(b),AghWrapByte(a))
#define ROAST_HEXCOLORW_XRGB(r,g,b)		ROAST_HEXCOLOR_XRGB(AghWrapByte(r),AghWrapByte(g),AghWrapByte(b))

#define ROAST_HEXCOLOR_MONO(v)			ROAST_HEXCOLOR_XRGB(v,v,v)
#define ROAST_HEXCOLORW_MONO(v)			ROAST_HEXCOLOR_XRGB(AghWrapByte(v),AghWrapByte(v),AghWrapByte(v))

#define ROAST_HEXCOLOR_BLUE				((color_t)0xff0000ff)
#define ROAST_HEXCOLOR_GREEN			((color_t)0xff00ff00)
#define ROAST_HEXCOLOR_RED				((color_t)0xffff0000)
#define ROAST_HEXCOLOR_PINK				((color_t)0xffff00ff)
#define ROAST_HEXCOLOR_CYAN				((color_t)0xff00ffff)
#define ROAST_HEXCOLOR_YELLOW			((color_t)0xffffff00)
#define ROAST_HEXCOLOR_WHITE			((color_t)0xffffffff)
#define ROAST_HEXCOLOR_BLACK			((color_t)0xff000000)
#define ROAST_HEXCOLOR_FULLWHITE		((color_t)0xffffffff)	//	ROAST_HEXCOLOR_WHITEɓ

#define ROAST_HEXCOLOR_NABLUE			((color_t)0x000000ff)
#define ROAST_HEXCOLOR_NAGREEN			((color_t)0x0000ff00)
#define ROAST_HEXCOLOR_NARED			((color_t)0x00ff0000)
#define ROAST_HEXCOLOR_NAPINK			((color_t)0x00ff00ff)
#define ROAST_HEXCOLOR_NACYAN			((color_t)0x0000ffff)
#define ROAST_HEXCOLOR_NAYELLOW			((color_t)0x00ffff00)
#define ROAST_HEXCOLOR_NAWHITE			((color_t)0x00ffffff)
#define ROAST_HEXCOLOR_NABLACK			((color_t)0x00000000)

#define ROAST_HEXCOLOR_FULLALPHA		((color_t)0xff000000)
#define ROAST_HEXCOLOR_ZEROALPHA		((color_t)0x00000000)

#define ROAST_HEXCOLOR_ZEROALPHA_FILTER(c)	(c&0x00ffffff)
#define ROAST_HEXCOLOR_FULLALPHA_FILTER(c)	(c|0xff000000)

#define ROAST_HEXCOLOR_NAMASK(c)		(c&0x00ffffff)
#define ROAST_HEXCOLOR_NRMASK(c)		(c&0xff00ffff)
#define ROAST_HEXCOLOR_NGMASK(c)		(c&0xffff00ff)
#define ROAST_HEXCOLOR_NBMASK(c)		(c&0xffffff00)

#define ROAST_HEXCOLOR_AMASK(c)			(c&0xff000000)
#define ROAST_HEXCOLOR_RMASK(c)			(c&0x00ff0000)
#define ROAST_HEXCOLOR_GMASK(c)			(c&0x0000ff00)
#define ROAST_HEXCOLOR_BMASK(c)			(c&0x000000ff)

#define ROAST_HEXCOLOR_GETA(c)			(ROAST_HEXCOLOR_AMASK(c)>>24)
#define ROAST_HEXCOLOR_GETR(c)			(ROAST_HEXCOLOR_RMASK(c)>>16)
#define ROAST_HEXCOLOR_GETG(c)			(ROAST_HEXCOLOR_GMASK(c)>>8)
#define ROAST_HEXCOLOR_GETB(c)			(ROAST_HEXCOLOR_BMASK(c))

#define ROAST_HEXCOLOR_CHANGEA(c,A)		(ROAST_HEXCOLOR_GETNAMASK(c)|(A<<24))
#define ROAST_HEXCOLOR_CHANGER(c,R)		(ROAST_HEXCOLOR_GETNRMASK(c)|(R<<16))
#define ROAST_HEXCOLOR_CHANGEG(c,G)		(ROAST_HEXCOLOR_GETNGMASK(c)|(G<<8))
#define ROAST_HEXCOLOR_CHANGEB(c,B)		(ROAST_HEXCOLOR_GETNBMASK(c)|(B))

			struct float4
			{
				float values[4];
				float4(float f1, float f2, float f3, float f4){
					values[0] = f1;
					values[1] = f2;
					values[2] = f3;
					values[3] = f4;
				}
			};

			struct vector_rgb
			{
				float r,g,b;
				vector_rgb(float r, float g, float b){
					this->r = r;
					this->g = g;
					this->b = b;
				}
			};
			struct vector_rgba
			{
				float r,g,b,a;
				vector_rgba(float r, float g, float b, float a){
					this->r = r;
					this->g = g;
					this->b = b;
					this->a = a;
				}
			};
			inline float4 d3dcolor_2_float4(const color_t &cl)
			{
				/*return float[4]{
								ROAST_HEXCOLOR_GETR(cl) / 255.0f,
								ROAST_HEXCOLOR_GETG(cl) / 255.0f,
								ROAST_HEXCOLOR_GETB(cl) / 255.0f,
								ROAST_HEXCOLOR_GETA(cl) / 255.0f
							};*/
				return float4(
					ROAST_HEXCOLOR_GETR(cl) / 255.0f,
					ROAST_HEXCOLOR_GETG(cl) / 255.0f,
					ROAST_HEXCOLOR_GETB(cl) / 255.0f,
					ROAST_HEXCOLOR_GETA(cl) / 255.0f
					);
			}
			inline vector_rgb d3dcolor_2_vectorrgb(const color_t &cl)
			{
				return vector_rgb(
					ROAST_HEXCOLOR_GETR(cl) / 255.0f,
					ROAST_HEXCOLOR_GETG(cl) / 255.0f,
					ROAST_HEXCOLOR_GETB(cl) / 255.0f
					);
			}
			inline vector_rgba d3dcolor_2_vectorrgba(const color_t &cl)
			{
				return vector_rgba(
					ROAST_HEXCOLOR_GETR(cl) / 255.0f,
					ROAST_HEXCOLOR_GETG(cl) / 255.0f,
					ROAST_HEXCOLOR_GETB(cl) / 255.0f,
					ROAST_HEXCOLOR_GETA(cl) / 255.0f
					);
			}
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__color_HPP__
