//	Roast+ License

#ifndef __SFJP_ROAST_EX__windows__window_HPP__
#define __SFJP_ROAST_EX__windows__window_HPP__

#include "roast/windows/control.hpp"

#define ROAST_BIT_NOT(VALUE,BIT)	(VALUE & (~BIT))

namespace roast
{
	namespace windows
	{
		////////////////////////////////////////////////////////////////

		struct window_detail_info
		{
			UINT nClassStyle;
			DWORD dwWindowStyle;
			DWORD dwWindowExStyle;
			int nShowWindow;
			HICON hIcon;
			HICON hSmallIcon;
			HCURSOR hCursor;
			HBRUSH hbrBackground;
			lpctstr_t szMenuByName;
			HMENU hMenu;
			
			/////////////

			window_detail_info(){
				memset(this, 0, sizeof(window_detail_info));

				//hIcon = LoadIcon(NULL,IDI_APPLICATION);
				hCursor = LoadCursor(NULL,IDC_ARROW);
				//hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
				hbrBackground = (HBRUSH)COLOR_BTNSHADOW;
				nClassStyle = 0;//CS_CLASSDC
				dwWindowStyle = WS_MINIMIZEBOX | /*WS_VISIBLE |*/ WS_CAPTION | WS_SYSMENU;
				enable_window_sizing();
				nShowWindow = SW_SHOWNORMAL;
			}

			////
			
			void set_class_style(UINT nClassStyle){ this->nClassStyle = nClassStyle; }
			void set_icon(HICON hIcon, HICON hSmallIcon=NULL){
				this->hIcon = hIcon;
				if ( hSmallIcon )
					this->hSmallIcon = hSmallIcon;
			}
			void set_cursor(HCURSOR hCursor){ this->hCursor = hCursor; }
			void set_background_brush(HBRUSH hbrBackground){ this->hbrBackground = hbrBackground; }
			void set_menu(lpctstr_t szMenuName){ this->szMenuByName = szMenuName; }
			void set_menu(HMENU hMenu){ this->hMenu = hMenu; }

			////

			void enable_window_sizing(){
				dwWindowStyle |= WS_SIZEBOX;
				enable_maximize();
			}
			void disable_window_sizing(){
				ROAST_BIT_NOT(dwWindowStyle, WS_SIZEBOX);
				disable_maximize();
			}
			void enable_drop_files(){ dwWindowExStyle |= WS_EX_ACCEPTFILES; }
			void enable_maximize(){ dwWindowStyle |= WS_MAXIMIZEBOX; }
			void disable_maximize(){ ROAST_BIT_NOT(dwWindowStyle, WS_MAXIMIZEBOX); }
			void disable_minimize(){ ROAST_BIT_NOT(dwWindowStyle, WS_MINIMIZEBOX); }
			void disable(){ dwWindowStyle |= WS_DISABLED; }
			void enable(){ ROAST_BIT_NOT(dwWindowStyle, WS_DISABLED); }

			void disable_close_button(){ nClassStyle |= CS_NOCLOSE; }
			void enable_ime(){ nClassStyle |= CS_IME; }
			void window_shadow(){
#if(_WIN32_WINNT >= 0x0501)	//	Enable Windows 2000 later
				nClassStyle |= CS_DROPSHADOW;
#endif
			}

			void enable_always_top(){ dwWindowExStyle |= WS_EX_TOPMOST; }
			void disable_always_top(){ ROAST_BIT_NOT(dwWindowExStyle, WS_EX_TOPMOST); }
			void tool_window(){ dwWindowExStyle |= WS_EX_TOOLWINDOW; }	//	No Icon, Small Title Bar, Button is Close Only.
			void dent_window(){ dwWindowExStyle |= WS_EX_CLIENTEDGE; }
			void title_right_align(){ dwWindowExStyle |= WS_EX_RIGHT; }

			void minimized_startup(){ nShowWindow = SW_MINIMIZE; }
			void maxmized_startup(){ nShowWindow = SW_SHOWMAXIMIZED; }
			void no_active_startup(){ nShowWindow = SW_SHOWNOACTIVATE; }
			void hide_startup(){ nShowWindow = SW_HIDE; }
			void hidden_window(){ nShowWindow = SW_HIDE; }
		};

		/////

		class window : public custom_control
		{
		public:
			window(lpctstr_t szWindowClassName) : custom_control(szWindowClassName) {}
			virtual ~window(){
				if ( m_hWnd != NULL )
				{
					unregist_window_class(m_szClassName, m_hAppInstance);
				}
			}
			
			bool start(
				lpctstr_t szWindowTitle,		//	Window Title
				int nWidth=CW_USEDEFAULT,		//	Window Width
				int nHeight=CW_USEDEFAULT,		//	Window Height
				HWND hWndParent=NULL,			//	Parent Window Handle 
				int nPositionX=CW_USEDEFAULT,	// EBhẺ̈ʒu
				int nPositionY=CW_USEDEFAULT,	// EBhȄc̈ʒu
				const window_detail_info& detail=window_detail_info(),
				LPVOID lpParam=NULL,		    //	Paramator
				HINSTANCE hInstance=NULL		//	Application Instance Handle (Windows 2000 later is NULL)
			)
			{
				window_class wc(m_szClassName, hInstance, &message_callback_base::message_callback_static<window> );
				wc.set_icon(detail.hIcon, detail.hSmallIcon);
				wc.set_cursor(detail.hCursor);
				wc.set_background_brush(detail.hbrBackground);
				wc.set_menu(detail.szMenuByName);
				wc.set_class_style(detail.nClassStyle);

				//	Regist Window Class
				if ( !regist_window_class(wc) )
					throw windows_control_exception("Window Class Regist Failed.");
					//return false;

				//	Start Window
				bool ret = custom_control::start(nWidth,nHeight,szWindowTitle,hWndParent,nPositionX,nPositionY,
					detail.dwWindowStyle, detail.dwWindowExStyle, detail.nShowWindow, lpParam, detail.hMenu, hInstance);
				if ( !ret )
					return false;

				//	UnRegist Window Class
				message_callback_base::regist_in_hwnd(m_hWnd);
				
				return ret;
			}

			void hide_window(){ ::ShowWindow(m_hWnd, SW_HIDE); }
			void minimize(){ ::ShowWindow(m_hWnd, SW_SHOWMINIMIZED); }
			void maxmize(){ ::ShowWindow(m_hWnd, SW_SHOWMAXIMIZED); }
			void restore_window(){ ::ShowWindow(m_hWnd, SW_RESTORE); }
		};

		////////////////////////////////////////////////////////////////
	}
}

#endif//__SFJP_ROAST_EX__windows__window_HPP__
