/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * XML̓ǂݍ݂ҏWEۑs܂B
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Xml {

	/**
	 * XML̕ҏWۑɕKvȃNX
	 * 
	 * @since 1.00
	 */
	private final DocumentBuilderFactory m_factory;

	/**
	 * XML̕ҏWۑɕKvȃNX
	 * 
	 * @since 1.00
	 */
	private final DocumentBuilder m_builder;

	/**
	 * XML̕ҏWۑɕKvȃNX
	 * 
	 * @since 1.00
	 */
	private Document m_document;

	/**
	 * [gGg
	 * 
	 * @since 1.00
	 */
	private Element m_rootElement;

	/**
	 * [gGg̖O
	 * 
	 * @since 1.00
	 */
	private final String m_rootElementName;

	/**
	 * Xml𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_rootElementName [gGg̖O
	 * @throws ParserConfigurationException dXML\G[ꍇ 
	 */
	private Xml(String p_rootElementName) throws ParserConfigurationException {
		m_rootElementName = p_rootElementName;
		m_factory = DocumentBuilderFactory.newInstance();
		m_builder = m_factory.newDocumentBuilder();
	}
	
	/**
	 * ̓Xg[ŏXmlIuWFNg𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_rootElementName [gGg̖O
	 * @param p_inputStream ͌
	 * @return XMLIuWFNg
	 * @throws ParserConfigurationException dXML\G[ꍇ 
	 * @throws IOException o͏̎sꍇ
	 * @throws SAXException XMLp[T̃G[ꍇ
	 */
	public static Xml createByInputStream(String p_rootElementName, InputStream p_inputStream) 
		throws ParserConfigurationException, SAXException, IOException {
		Xml returnValue = new Xml(p_rootElementName);
		// p[XsDocumentIuWFNg擾
		returnValue.m_document = returnValue.m_builder.parse(p_inputStream);
		// [gvf擾
		returnValue.m_rootElement = returnValue.m_document.getDocumentElement();
		// idAgr[g̐ݒsȂ
		returnValue.setIdAttribute();
		return returnValue;
	}

	/**
	 * XMLt@CǂݍXmlIuWFNg𐶐܂B
	 * XMLt@C݂Ȃꍇ͐VK쐬܂B
	 * 
	 * @since 1.00
	 * @param p_rootElementName [gGg̖O
	 * @param p_filePath ͌XMLt@C̃pX
	 * @return XMLIuWFNg
	 * @throws ParserConfigurationException dXML\G[ꍇ 
	 * @throws IOException o͏̎sꍇ
	 * @throws SAXException XMLp[T̃G[ꍇ
	 */
	public static Xml createByFile(String p_rootElementName, String p_filePath) 
		throws ParserConfigurationException, SAXException, IOException {
		Xml returnValue = new Xml(p_rootElementName);
		// t@C̑݊mF
		File f = new File(p_filePath);
		if (f.exists()) {
			// p[XsDocumentIuWFNg擾
			returnValue.m_document = returnValue.m_builder.parse(f);
			// [gvf擾
			returnValue.m_rootElement = returnValue.m_document.getDocumentElement();
		} else {
			// VKwlk̐
			returnValue.createNewXML();
		}
		// idAgr[g̐ݒsȂ
		returnValue.setIdAttribute();
		return returnValue;
	}
	
	/**
	 * IDAgr[g̐ݒsȂ܂B
	 * 
	 * @since 1.00
	 */
	protected void setIdAttribute() {
	}

	/**
	 * XMLVK쐬܂B
	 * 
	 * @since 1.00
	 */
	private final void createNewXML() {
		// VKhLg̍쐬
		DOMImplementation domImpl = m_builder.getDOMImplementation();
		m_document = domImpl.createDocument("", m_rootElementName, null);
		m_document.setXmlStandalone(true);
		// [gvf擾
		m_rootElement = m_document.getDocumentElement();
	}

	/**
	 * XML̓eNA܂B
	 * 
	 * @since 1.00
	 */
	public final void clear() {
		// XMLIuWFNg̃f[^NA
		m_builder.reset();
		// XMLt@C̍쐬
		createNewXML();
	}

	/**
	 * XMLt@Cɕۑ܂B
	 * 
	 * @since 1.00
	 * @param p_filePath o͐t@C̃pX
	 * @throws TransformerException t@Co͒Ɉُ킪ꍇ
	 * @throws IOException t@C̃N[YɎsꍇ
	 */
	public final void save(String p_filePath) throws TransformerException, IOException {
		TransformerFactory tft = TransformerFactory.newInstance();
		Transformer tf = tft.newTransformer();
		DOMSource src = new DOMSource();
		src.setNode(m_document);
		StreamResult sr = new StreamResult();
		FileOutputStream f = new FileOutputStream(p_filePath);
		sr.setOutputStream(f);
		tf.transform(src, sr);
		f.close();
	}

	/**
	 * w肵^O݂邩Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @return w肵^O݂ꍇtrue
	 */
	public final boolean isExistElement(Element p_parentElement, String p_tagName) {
		NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
		if (nodeList == null) 
			return false;
		Element returnValue = (Element) nodeList.item(0);
		if (returnValue == null)
			return false;
		return true;
	}
	
	/**
	 * w肵^O̍ŏ̃GgԂ܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @return Gg
	 */
	public final Element getElement(Element p_parentElement, String p_tagName) {
		NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
		if (nodeList == null) 
			throw new RuntimeException("Error getElement NodeList :" + p_tagName);
		Element returnValue = (Element) nodeList.item(0);
		if (returnValue == null)
			throw new RuntimeException("Error getElement Element :" + p_tagName);
		return returnValue;
	}

	/**
	 * w肵^ÕGgׂĂԂ܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @return Gg̃Xg
	 */
	public final ArrayList<Element> getElementList(Element p_parentElement, String p_tagName) {
		NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
		if (nodeList == null) 
			throw new RuntimeException("Error getElementList NodeList :" + p_tagName);
		ArrayList<Element> returnValue = new ArrayList<Element>();
		for (int i=0;i<nodeList.getLength();i++) {
			Element e = (Element) nodeList.item(i);
			if (e == null)
				throw new RuntimeException("Error getElementList Element :" + p_tagName);
			returnValue.add(e);
		}
		return returnValue;
	}
	
	/**
	 * w肵^ÕGg̒lԂ܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @return l
	 */
	public final String getValue(Element p_parentElement, String p_tagName) {
		Element elChild = getElement(p_parentElement, p_tagName);
		Node ndChild = elChild.getFirstChild();
		if (ndChild == null)
			throw new RuntimeException("Error getValue Node :" + p_tagName);
		return ndChild.getNodeValue();
	}

	/**
	 * w肵^ÕGgɒlݒ肵܂B
	 * w肵^ÕGg݂Ȃ΃GgVK쐬Ēlݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @param p_value l
	 */
	public final void setValue(Element p_parentElement, String p_tagName, String p_value) {
		NodeList nodeList = p_parentElement.getElementsByTagName(p_tagName);
		Element elChild;
		if (nodeList.getLength()<=0) {
			elChild = createValue(p_parentElement, p_tagName, p_value);			
		} else {
			elChild = (Element) nodeList.item(0);
			if (elChild == null)
				throw new RuntimeException("Error setValue Element :" + p_tagName);
		}
		Node ndChild = elChild.getFirstChild();
		if (ndChild == null)
			throw new RuntimeException("Error setValue Node :" + p_tagName);
		ndChild.setNodeValue(p_value);
	}

	/**
	 * w肵^O̒l̃XgԂ܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @return l̃Xg
	 */
	public final ArrayList<String> getValueList(Element p_parentElement, String p_tagName) {
		ArrayList<String> returnValue = new ArrayList<String>();
		NodeList nodelist = p_parentElement.getElementsByTagName(p_tagName);
		if (nodelist == null) 
			throw new RuntimeException("Error getValueList NodeList :" + p_tagName);
		for (int i=0;i<nodelist.getLength();i++) {
			Element elChild = (Element) nodelist.item(i);
			if (elChild == null)
				throw new RuntimeException("Error getValueList Element :" + p_tagName);
			Node ndChild = elChild.getFirstChild();
			if (ndChild == null)
				throw new RuntimeException("Error getValueList Node :" + p_tagName);
			returnValue.add(ndChild.getNodeValue());
		}
		return returnValue;
	}

	/**
	 * w肵^O̒l̃Xgu܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @param p_valueList l̃Xg
	 */
	public final void setValueList(Element p_parentElement, String p_tagName,  ArrayList<String> p_valueList) {
		// Âl̍폜
		NodeList nodelist = p_parentElement.getElementsByTagName(p_tagName);
		if (nodelist == null)
			throw new RuntimeException("Error setValueList NodeList :" + p_tagName);
		ArrayList<Node> removelist = new ArrayList<Node>();
		for (int i=0;i<nodelist.getLength();i++) {
			removelist.add(nodelist.item(i));
		}
		for (int i=0;i<removelist.size();i++) {
			Node child = removelist.get(i);
			if (child == null)
				throw new RuntimeException("Error setValueList Element :" + p_tagName);
			p_parentElement.removeChild(child);
		}
		// Vl̒ǉ
		for (String s: p_valueList) {
			createValue(p_parentElement, p_tagName, s);
		}
	}

	/**
	 * eGgzɐVȃGg쐬܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @return Gg
	 */
	public final Element createElement(Element p_parentElement, String p_tagName) {
		Element returnValue = m_document.createElement(p_tagName);
		p_parentElement.appendChild(returnValue);
		return returnValue;
	}	
	
	/**
	 * eGgzɐVȒl쐬܂B
	 * 
	 * @since 1.00
	 * @param p_parentElement eGg
	 * @param p_tagName ^O
	 * @param p_value l
	 * @return lZbgGg
	 */
	private final Element createValue(Element p_parentElement, String p_tagName, String p_value) {
		Element e = createElement(p_parentElement, p_tagName);
		e.appendChild(m_document.createTextNode(p_value));
		return e;
	}
	
	/**
	 * [gGgԂ܂B
	 * 
	 * @since 1.00
	 * @return [gGg
	 */
	public final Element getRootElement() {
		return m_rootElement;
	}
	
}
