/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;

/**
 * select^OɈ͂܂Ă邷ׂĂoption^ÕXg
 *
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HtmlOptionList implements Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * option^ÕXg
	 * 
	 * @since 1.00
	 */
	private ArrayList<HtmlOption> m_htmlOptionList;
	
	/**
	 * HtmlOptionList𐶐܂B
	 * 
	 * @since 1.00
	 */
	public HtmlOptionList() {
		m_htmlOptionList = new ArrayList<HtmlOption>();
	}
	
	/**
	 * option^OXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_htmlOption ǉoption^O
	 */
	protected void add(HtmlOption p_htmlOption) {
		m_htmlOptionList.add(p_htmlOption);
	}
	
	/**
	 * IĂoption^OԂ܂B
	 * ݂ȂꍇnullԂ܂B
	 * 
	 * @since 1.00
	 * @return IԂoption^O
	 */
	public HtmlOption getSelectedItem() {
		for (int i=0;i<m_htmlOptionList.size();i++) {
			HtmlOption htmlOption = m_htmlOptionList.get(i);
			if (htmlOption.isSelected()) {
				return htmlOption;
			}
		}
		return null;
	}
	
	/**
	 * ׂĂoption^ȎIԂ܂B
	 * 
	 * @since 1.00
	 */
	private void selectOff() {
		for (int i=0;i<m_htmlOptionList.size();i++) {
			HtmlOption htmlOption = m_htmlOptionList.get(i);
			htmlOption.setSelected(false);
		}
	}
	
	/**
	 * w肵^CgɃ}b`option^OIԂɂ܂B
	 * 
	 * @since 1.00
	 * @param p_title IԂɂoption^Õ^Cg
	 * @throws HtmlFormException w肳ꂽ^CgɃ}b`option^O݂Ȃꍇ
	 */
	public void selectByTitle(String p_title) throws HtmlFormException {
		selectOff();
		for (int i=0;i<m_htmlOptionList.size();i++) {
			HtmlOption htmlOption = m_htmlOptionList.get(i);
			if (htmlOption.getTitle().equals(p_title)) {
				htmlOption.setSelected(true);
				return;
			}
		}
		throw new HtmlFormException("method:HtmlOptionList.selectByTitle p_title=" + p_title);
	}

	/**
	 * w肵valueɃ}b`option^OIԂɂ܂B
	 * 
	 * @since 1.00
	 * @param p_value IԂɂoption^Ovalue
	 * @throws HtmlFormException w肳ꂽvalueɃ}b`option^O݂Ȃꍇ
	 */
	public void selectByValue(String p_value) throws HtmlFormException {
		selectOff();
		for (int i=0;i<m_htmlOptionList.size();i++) {
			HtmlOption htmlOption = m_htmlOptionList.get(i);
			if (htmlOption.getValue().equals(p_value)) {
				htmlOption.setSelected(true);
				return;
			}
		}
		throw new HtmlFormException("method:HtmlOptionList.selectByValue p_value=" + p_value);
	}
	
	/**
	 * w肳ꂽoption^OXgƌ`mF܂B
	 * 
	 * @since 1.00
	 * @param p_other option^OXg
	 * @return w肳ꂽoption^OXgƌ`ꍇtrueԂ܂B
	 */
	public boolean equalsFormat(HtmlOptionList p_other) {
		if (m_htmlOptionList.size()!=p_other.m_htmlOptionList.size()) 
			return false; 
		for (int i=0;i<m_htmlOptionList.size();i++) {
			HtmlOption me = m_htmlOptionList.get(i);
			HtmlOption other = p_other.m_htmlOptionList.get(i);
			if (!me.equalsFormat(other)) return false;
		}
		return true;	
	}
	
	/**
	 * option^O̓ew肵o̓Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o̓Xg[
	 */
	public void print(PrintStream p_out) {
		for (int i=0; i<m_htmlOptionList.size(); i++) {
			HtmlOption htmlOption = m_htmlOptionList.get(i);
			htmlOption.print(p_out);
		}
	}

}
