/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.net;

import java.io.*;
import java.net.*;

import jp.robotbrain.common.StringEx;
import jp.robotbrain.common.TextFile;
import jp.robotbrain.html.HtmlForm;
import jp.robotbrain.html.HtmlFormException;

/**
 * WebʐM(http,https)sNX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Web {

	/**
	 * URL
	 * 
	 * @since 1.00
	 */
	private URL m_url;

	/**
	 * httpRlNV
	 * 
	 * @since 1.00
	 */
	private HttpURLConnection m_connection;

	/**
	 * http_CNg(R[h3xx̗v)邩Ȃ
	 * 
	 * @since 1.00
	 */
	private boolean m_autoRedirects;
	
	/**
	 * httpʐMŎ擾CookiẽXg
	 * 
	 * @since 1.10
	 */
	private CookieList m_cookieList;
	
	/**
	 * httpwb_[Xg
	 * 
	 * @since 1.12
	 */
	private final HttpHeaderList m_httpHeaderList;

	/**
	 * http̃X|XƂĎ󂯎html̕Zbg
	 * 
	 * @since 2.10
	 */
	private final String m_charset;
	
	/**
	 * WebʐMCX^X𐶐܂BCX^XɒOɃANZXURLێ
	 * Refererwb_[𐶐ACookie̕ێƑMs܂̂ŁÄقȂTCg
	 * ƒʐMꍇ̓TCgɃCX^X𐶐ĂB܂ÃRXgN^ŃCX^X
	 * Javas̃o[W("Java/1.6.0_10"Ȃ)UserAgentɂȂ܂B
	 * ȂAgetCharSet\bhg΃CX^XOɕZbg𒲂ׂ邱Ƃł܂B
	 *  
	 * @since 2.10
	 * @param p_charset http̃X|XƂĎ󂯎html̕Zbg
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 */
	public Web(String p_charset) {
		m_autoRedirects = false;
		m_cookieList = new CookieList();
		m_charset = p_charset;
		m_httpHeaderList = new HttpHeaderList();
	}
	
	/**
	 * WebʐMCX^X𐶐܂BCX^XɒOɃANZXURLێ
	 * Refererwb_[𐶐ACookie̕ێƑMs܂̂ŁÄقȂTCg
	 * ƒʐMꍇ̓TCgɃCX^X𐶐ĂB
	 * ȂAgetCharSet\bhg΃CX^XOɕZbg𒲂ׂ邱Ƃł܂B
	 *  
	 * @since 2.10
	 * @param p_charset http̃X|XƂĎ󂯎html̕Zbg
	 * @param p_httpUserAgent httpNGXgUserAgentw肵܂B
	 *    null""w肵ꍇJavas̃o[W("Java/1.6.0_10"Ȃ)UserAgentɂȂ܂B<br>
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 */
	public Web(String p_charset, String p_httpUserAgent) {
		m_autoRedirects = false;
		m_cookieList = new CookieList();
		m_charset = p_charset;
		m_httpHeaderList = new HttpHeaderList();
		if (p_httpUserAgent!=null && p_httpUserAgent.length()>0)
				m_httpHeaderList.add(new HttpHeader("User-Agent", p_httpUserAgent));
	}
	
	/**
	 * GEThtml̃eLXgf[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	private String getHtml(String p_URL, String p_charset, 
			HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
		// NbL[t
		HttpHeaderList reqHeader = new HttpHeaderList();
		if (p_httpHeaderList!=null) reqHeader.addList(p_httpHeaderList);
		HttpHeader cookieHeader = m_cookieList.createRequestCookie(p_URL, p_charset);
		if (cookieHeader!=null) reqHeader.add(cookieHeader);
		// NGXgM
		try {
			setURL(p_URL);
			if (reqHeader!=null) setRequestProperties(reqHeader);
			doGet();
			if (getStatusCode() >= 400) {
				throw new IOException("getHtml HttpError HttpStatusCode=" + getStatusCode());
			}
		} catch (IOException e) {
			throw new HttpSendException("getHtml SendError URL="+p_URL+" :"+e.getMessage());
		}	
		// X|XM
		String returnValue = "";
		try {
			returnValue = getResponseText(p_charset);
		} catch (IOException e) {
			throw new HttpRecvException("getHtml RecvError URL="+p_URL+" :"+e.getMessage());
		}
		importResponseCookie();
		return returnValue;
	}

	/**
	 * POSThtml̃eLXgf[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @param p_queryString NG
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	private String postHtml(String p_URL, String p_queryString, String p_charset,
			HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
		// NbL[t
		HttpHeaderList reqHeader = new HttpHeaderList();
		if (p_httpHeaderList!=null) reqHeader.addList(p_httpHeaderList);
		HttpHeader cookieHeader = m_cookieList.createRequestCookie(p_URL, p_charset);
		if (cookieHeader!=null) reqHeader.add(cookieHeader);
		// NGXgM
		try {
			setURL(p_URL);
			if (reqHeader!=null) setRequestProperties(reqHeader);
			doPost(p_queryString);
			if (getStatusCode() >= 400) {
				throw new HttpSendException("postHtml HttpError URL="+p_URL+" QueryString="+p_queryString+ 
						" HttpStatusCode=" + getStatusCode());
			}
		} catch (IOException e) {
			throw new HttpSendException("postHtml SendError URL="+p_URL+" QueryString="+p_queryString+
					" :"+e.getMessage());
		}
		// X|XM
		String returnValue = "";
		try {
			returnValue = getResponseText(p_charset);
		} catch (IOException e) {
			throw new HttpRecvException("postHtml RecvError URL="+p_URL+" QueryString="+p_queryString+
					" :"+e.getMessage());
		}
		importResponseCookie();
		return returnValue;
	}
	
	/**
	 * URLZbg܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private void setURL(String p_URL) throws IOException {
		// URL IuWFNg̐
		m_url = new URL(p_URL);
		// HttpURLConnectionIuWFNg̐
		m_connection = (HttpURLConnection) m_url.openConnection();
		// _CNg̎ݒ
		if (!m_autoRedirects) {
			m_connection.setInstanceFollowRedirects(false);
		}
	}

	/**
	 * GETNGXg𔭍s܂B
	 * 
	 * @since 1.00
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private void doGet() throws IOException {
		// NGXg\bh
		m_connection.setRequestMethod("GET");
		// ڑENGXgsiSYN,SYN/ACK,ACK̒ʐMj
		m_connection.connect();
	}

	/**
	 * httpwb_[̃XgZbg܂B
	 * 
	 * @since 1.00
	 * @param p_httpHeaderList httpwb_[̃Xg
	 */
	private void setRequestProperties(HttpHeaderList p_httpHeaderList) {
		for (int i = 0; i < p_httpHeaderList.size(); i++) {
			HttpHeader hd = p_httpHeaderList.get(i);
			m_connection.setRequestProperty(hd.getName(), hd.getValue());
		}
	}

	/**
	 * POSTNGXg𔭍s܂B
	 * 
	 * @since 1.00
	 * @param p_queryString NG
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private void doPost(String p_queryString) throws IOException {
		// NGXg\bh
		m_connection.setRequestMethod("POST");
		// bZ[Wꍇ
		setRequestMessage(p_queryString);
		// ڑENGXgs
		m_connection.connect();
	}

	/**
	 * NGXgbZ[Wݒ肵܂BiPOSTɎgpj
	 * 
	 * @since 1.00
	 * @param p_queryString NG
	 * @throws IOException NGXgbZ[W̐ݒɎsꍇ
	 */
	private void setRequestMessage(String p_queryString) throws IOException {
		// NGXg{fB𓊂悤ɂ
		m_connection.setDoOutput(true);
		// NGXg{fBMIME application/x-www-form-urlencoded
		m_connection.setRequestProperty("Content-Type",
				"application/x-www-form-urlencoded");
		// NGXg{fB̒
		m_connection.setRequestProperty("Content-Length", Integer.toString(p_queryString
				.length()));
		// NGXgbZ[W𗬂ޏo̓Xg[
		BufferedWriter outer = new BufferedWriter(new OutputStreamWriter(m_connection
				.getOutputStream()));
		outer.write(p_queryString);
		outer.flush();
		outer.close();
	}

	/**
	 * httpXe[^XR[hԂ܂B
	 * xNGXgĂȂꍇ-1Ԃ܂B
	 * 
	 * @since 1.00
	 * @return Xe[^XR[h
	 * @throws IOException  httpXe[^XR[h̎擾Ɏsꍇ
	 */
	private int getStatusCode() throws IOException {
		if (m_connection==null) return -1;
		// GET/POSTNGXg𔭍sĂ
		return m_connection.getResponseCode();
	}

	/**
	 * X|Xwb_[Wo͂܂BfobOp\bh
	 * 
	 * @since 1.00
	 */
	protected void printHttpHeaderList() {
		if (m_connection==null) return;		
		int i = 0;
		String name = "";
		String value = "";
		while (true) {
			++i;
			name = m_connection.getHeaderFieldKey(i);
			value = m_connection.getHeaderField(i);
			if (value==null) break;
			System.out.println(name + ":" + value);
		}
	}

	/**
	 * X|Xwb_[̃XgԂ܂B
	 * 
	 * @since 2.10
	 * @return X|Xwb_[̃Xg
	 */
	private HttpHeaderList getHttpHeaderList() {
		if (m_connection==null) return null;
		HttpHeaderList returnValue = new HttpHeaderList();
		int i = 0;
		while (true) {
			++i;
			String name = m_connection.getHeaderFieldKey(i);
			String value = m_connection.getHeaderField(i);
			if (value==null) break;
			returnValue.add(new HttpHeader(name, value));
		}
		return returnValue;
	}
	
	/**
	 * X|Xwb_[Ɋ܂܂NbL[荞݂܂B
	 * @throws CookieException Cookie͂Ɏsꍇ
	 * 
	 * @since 1.10
	 */
	private void importResponseCookie() throws CookieException {
		if (m_connection==null) return;		
		int i = 0;
		while (true) {
			String name = m_connection.getHeaderFieldKey(i);
			String value = m_connection.getHeaderField(i);
			if (value==null) break;
			if (name!=null) {
				if (name.equalsIgnoreCase("Set-Cookie")) {
					m_cookieList.importResponseCookie(getURL(),value);
				}
			}
			i++;
		}
	}
	
	/**
	 * X|Xwb_[̒lԂ܂B
	 * xNGXgĂȂꍇ͋󕶎""Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_name X|Xwb_[̖O
	 * @return X|Xwb_[̒l
	 */
	private String getResponseHeaderValue(String p_name) {
		if (m_connection==null) return "";		
		int i = 0;
		while (true) {
			String name = m_connection.getHeaderFieldKey(i);
			String value = m_connection.getHeaderField(i);
			if (value==null) break;
			if (name!=null) {
				if (name.equals(p_name)) {
					return value;
				}
			}
			i++;
		}
		return "";
	}
	
	/**
	 * X|X󂯎邽߂̃Xg[Ԃ܂B
	 * 
	 * @since 1.00
	 * @return X|X󂯎邽߂̃Xg[
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private InputStream getResponseStream() throws IOException {
		return m_connection.getInputStream();
	}

	/**
	 * X|X{fBeLXgƂĕԂ܂B
	 * 
	 * @since 1.00
	 * @param p_charSet Zbg
	 * @return X|X{fB̕
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private String getResponseText(String p_charSet) throws IOException {
		BufferedReader inner = new BufferedReader(new InputStreamReader(
				getResponseStream(), p_charSet));
		String response = "";
		String line = "";
		while ((line = inner.readLine()) != null) {
			response += line + TextFile.LSP;
		}
		inner.close();
		return response;
	}

	/**
	 * form̑MsȂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * httpNGXgReferer,Cookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B<br>
	 * Refererwb_[ɂ͒OɃANZXURLZbg܂B<br>
	 * 
	 * @since 2.10
	 * @param p_URL formMURL
	 * @param p_htmlForm tH[͓̓e
	 * @return X|Xhtml
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 * @throws HtmlFormException NG̐Ɏsꍇ
	 */
	public String sendForm(String p_URL, HtmlForm p_htmlForm) 
			throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
		HttpHeaderList httpHeaderList = new HttpHeaderList();
		httpHeaderList.addList(m_httpHeaderList);
		HttpHeader httpHeader = getReferer();
		if (httpHeader!=null) httpHeaderList.add(httpHeader);
		return sendForm(p_URL, m_charset, httpHeaderList, p_htmlForm);
	}
	
	/**
	 * form̑MsȂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * httpNGXgCookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B
	 * HttpHeaderListɒǉEύXhttpwb_[΂̃wb_[NGXgɓ܂B
	 * wb_[(User-AgentȂ)HttpHeaderListɒǉꍇ͂̓e
	 * u܂(Cookie͒u܂)B
	 * 
	 * @since 1.00
	 * @param p_URL formMURL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @param p_htmlForm tH[͓̓e
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 * @throws HtmlFormException NG̐Ɏsꍇ
	 */
	private String sendForm(String p_URL, String p_charset, 
			HttpHeaderList p_httpHeaderList, HtmlForm p_htmlForm) 
			throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
		if (p_htmlForm.getAction().length()<=0) return null;
		String returnValue = "";
		if (p_htmlForm.getMethod().equals("post")) {
			// POST
			try {
				String queryString = p_htmlForm.createQueryString(p_charset);
				returnValue = postHtml(p_URL,queryString,p_charset,p_httpHeaderList);
			} catch (UnsupportedEncodingException e) {
				throw new HttpSendException("sendForm POST createQueryString Error: " + e.getMessage());
			}
		} else {
			// GET
			try {
				String getUrl = p_URL + "?" + p_htmlForm.createQueryString(p_charset);
				returnValue = getHtml(getUrl,p_charset,p_httpHeaderList);
			} catch (UnsupportedEncodingException e) {
				throw new HttpSendException("sendForm GET createQueryString Error: " + e.getMessage());
			}
		}
		String redirect = redirectHtml(p_charset, p_httpHeaderList);
		if (!redirect.equals("")) return redirect;
		return returnValue;
	}

	/**
	 * w肵URLhtmlԂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * Referer,Cookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B<br>
	 * Refererwb_[ɂ͒OɃANZXURLZbg܂B<br>
	 * 
	 * @since 2.10
	 * @param p_URL URL
	 * @return X|Xhtml
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	public String go(String p_URL) throws HttpSendException, HttpRecvException, CookieException {
		HttpHeaderList httpHeaderList = new HttpHeaderList();
		httpHeaderList.addList(m_httpHeaderList);
		HttpHeader httpHeader = getReferer();
		if (httpHeader!=null) httpHeaderList.add(httpHeader);
		return go(p_URL, m_charset, httpHeaderList);
	}
	
	/**
	 * w肵URLhtmlԂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * Referer,Cookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B
	 * HttpHeaderListɒǉEύXhttpwb_[΂̃wb_[NGXgɓ܂B
	 * wb_[(User-AgentȂ)HttpHeaderListɒǉꍇ͂̓eŒu܂
	 * (Cookie͒u܂)B
	 * 
	 * @since 1.10
	 * @param p_URL URL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	private String go(String p_URL, String p_charset, HttpHeaderList p_httpHeaderList) 
		throws HttpSendException, HttpRecvException, CookieException {
		String returnValue = getHtml(p_URL,p_charset,p_httpHeaderList);
		String redirect = redirectHtml(p_charset, p_httpHeaderList);
		if (!redirect.equals("")) return redirect;
		return returnValue;
	}
	
	/**
	 * ߂ɃANZXURLRefererwb_[쐬܂B
	 * 
	 * @since 1.12
	 * @return Refererwb_[AxANZXĂȂꍇnullԂ܂
	 */
	private HttpHeader getReferer() {
		String prevUrl = getURL();
		if (prevUrl==null) return null;
		if (prevUrl.equals("")) return null;
		return new HttpHeader("Referer",prevUrl);
	}
	
	
	/**
	 * httpwb_[LocationǂėUHtml擾܂B
	 * 
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	private String redirectHtml(String p_charset, HttpHeaderList p_httpHeaderList) 
		throws HttpSendException, HttpRecvException, CookieException {
		String returnValue = "";
		for (;;) {
	        String nextUrl = getResponseHeaderValue("Location");
	        if (nextUrl.equals("")) break;
	        returnValue = getHtml(nextUrl, p_charset, p_httpHeaderList);
		}
		return returnValue;
	}
	
	/**
	 * ݂URLԂ܂B_CNgɌ݂URLmFł܂B
	 * xNGXgĂȂꍇnullԂ܂B
	 * 
	 * @since 1.00
	 * @return ݂URL
	 */
	public String getURL() {
		if (m_connection==null) return null;
		return m_connection.getURL().toString();
	}

	/**
	 * w肵URLhtmlGETăX|X̒Content-Typewb_[
	 * META錾Content-TypeǂŕZbg𔻒肵܂B
	 * UTF-8,Shift_JIS,EUC-JP̂Rp^[T|[g܂B
	 * 
	 * @since 2.10
	 * @param p_url ΏۂURLBhtmlԂURLw肵ĂB
	 * @return ZbgBZbg킩ȂꍇnullB
	 */
	public static String getCharSet(String p_url) {
		return getCharSet(p_url, null);
	}
	
	/**
	 * w肵URLhtmlGETăX|X̒Content-Typewb_[
	 * META錾Content-TypeǂŕZbg𔻒肵܂B
	 * UTF-8,Shift_JIS,EUC-JP3p^[T|[g܂B
	 * 
	 * @since 2.10
	 * @param p_url ΏۂURLBhtmlԂURLw肵ĂB
	 * @param p_httpUserAgent httpNGXgUserAgentw肵܂B
	 * @return ZbgBZbg킩ȂꍇnullB
	 */
	public static String getCharSet(String p_url, String p_httpUserAgent) {
		try {
			Web web = new Web("SJIS", p_httpUserAgent);
			String res = web.go(p_url);
			HttpHeader header = web.getHttpHeaderList().get("Content-Type");
			String returnValue = null;
			// meta^OŔ
			String meta = extractContentTypeTag(res);
			if (meta!=null && meta.length()>0) {
				returnValue = createCharset(meta);
				if (returnValue!=null) return returnValue;
			}
			// httpwb_[Ŕ
			returnValue = createCharset(header.getValue());
			if (returnValue!=null) return returnValue;
			return null;
		} catch (HttpSendException e) {
			return null;
		} catch (HttpRecvException e) {
			return null;
		} catch (CookieException e) {
			return null;
		}
	}
	
	/**
	 * w肳ꂽ̒meta錾Content-Type擾܂B
	 * 
	 * @since 2.10
	 * @param p_src oΏhtml̓e
	 * @return meta錾Content-Type̋Lqe
	 */
	private static String extractContentTypeTag(String p_src) {
		String regex = "<meta\\s*http-equiv\\s*=\\s*(?:Content-Type|\"Content-Type\"|\'Content-Type\')(.+?)>";
		return StringEx.findByRegex(p_src, regex, 1);
	}
	
	/**
	 * w肳ꂽcharsetLqhttpʐMŎgZbg𐶐܂B
	 * 
	 * @since 2.10
	 * @param p_src charsetLq
	 * @return httpʐMŎgZbg
	 */
	private static String createCharset(String p_src) {
		String charset = null;
		charset = StringEx.findByRegex(p_src, "(?:(charset\\s*=\\s*utf-8)|(charset\\s*=\\s*\"utf-8\")|(charset\\s*=\\s*\'utf-8\'))", 0);
		if (charset!=null && charset.length()>0) return "UTF-8";
		charset = StringEx.findByRegex(p_src, "(?:(charset\\s*=\\s*Shift_JIS)|(charset\\s*=\\s*\"Shift_JIS\")|(charset\\s*=\\s*\'Shift_JIS\'))", 0);
		if (charset!=null && charset.length()>0) return "SJIS";
		charset = StringEx.findByRegex(p_src, "(?:(charset\\s*=\\s*EUC-JP)|(charset\\s*=\\s*\"EUC-JP\")|(charset\\s*=\\s*\'EUC-JP\'))", 0);
		if (charset!=null && charset.length()>0) return "EUC_JP";
		return null;
	}
	
}
