/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * wړ(EMA)C
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class EmaLine extends IndexLine {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * EMAZô߂Ɏg|Cg
	 * 
	 * @since 1.00
	 */
	private final int m_pcount;

	/**
	 * EMAZon߂\[XC̃|Cg~ϐ
	 * 
	 * @since 1.00
	 */
	private final int m_accumulateCount;
	
	/**
	 * EmaLine𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_pcount EMAZô߂Ɏg|Cg
	 */
	public EmaLine(int p_pcount) {
		super();
		m_pcount = p_pcount;
		m_accumulateCount = p_pcount;
	}

	/**
	 * EmaLine𐶐܂BEMAC̏ϒl߂^C~O
	 * 킹ꍇ͂̃RXgN^g܂BiMACDŎgpĂ܂j
	 * 
	 * @since 1.00
	 * @param p_pcount EMAZô߂Ɏg|Cg
	 * @param p_accumulateCount EMAZon߂\[XC̃|Cg~ϐ
	 */
	public EmaLine(int p_pcount, int p_accumulateCount) {
		super();
		m_pcount = p_pcount;
		m_accumulateCount = p_accumulateCount;
	}
	
	/**
	 * \[XCEMAZoăCɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 */
	public void addPoint(IndexLine p_src) {
		// TCY`FbN
		if (p_src==null) return;
		if (p_src.size()<m_accumulateCount) return; 
		// ̏ꍇ
		if (getObjectList().size()<=0) {
			// ŏ̒liw̒Pړρj߂
			IndexLine tail = p_src.getTailLine(m_pcount);
			double avg = UtilSignal.calcAvg(tail);
			// C֒ǉ
			add(new IndexPoint(p_src.getLast().getTag(), avg));
		// 2ڈȍ~
		} else {
			double prevValue = getLast().getValue();
			double curValue = p_src.getLast().getValue();
			// wړςvZ
			double a = 2 / ((double)m_pcount + 1);
			double value = prevValue + a * (curValue - prevValue);
			// C֒ǉ
			add(new IndexPoint(p_src.getLast().getTag(), value));
		}
	}	
	
}
