/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * VOio̓ubN<br>
 * ̓VOi""""ɂȂɃ^C}[N
 * w肵Ԃo߂AftHgVOio͂܂B
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalBlock
@EnabledDefaultSignal
@GeneDefaultLabelList(values={"timerMinute"})
@InputComponentList(values={"@Signal"})
public class TimerSignalBlock extends SignalBlock {

	/**
	 * ^C}[Jñ^O
	 * 
	 * @since 2.05
	 */
	private Tag m_beginTimeTag;

	/**
	 * ^C}[Ĩ^O
	 * 
	 * @since 2.05
	 */
	private Tag m_endTimeTag;
	
	/**
	 * ^C}[̕
	 * 
	 * @since 2.05
	 */
	private int m_timerMinute;
	
	/**
	 * TimerSignalBlock𐶐܂B
	 * 
	 * @since 2.05
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_geneList p[^Xg
	 * @param p_timerMinuteLabel ^C}[̕b̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public TimerSignalBlock(String p_label, int p_priority, GeneList p_geneList,
			String p_timerMinuteLabel) throws GeneListException {
		super(p_label, p_priority);
		m_beginTimeTag = null;
		m_endTimeTag = null;
		m_timerMinute = p_geneList.getGene(p_timerMinuteLabel).getIntValue();
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.SignalBlock#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		Tag inputTag = getInputTag();
		if (inputTag==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		JudgmentResult returnValue = new JudgmentResult(inputTag,NmSignal.NOSIGNAL);
		if (m_beginTimeTag!=null && m_endTimeTag!=null && 
				m_endTimeTag.calcTimeDifference(inputTag)>0) {
			// ^C}[̏
			m_beginTimeTag = null;
			m_endTimeTag = null;
		}	
		if (m_beginTimeTag==null) {
			// ^C}[NĂȂ
			JudgmentResult inputSignal = super.getJudgmentResult();
			if (inputSignal.getSignal()==NmSignal.LONG || inputSignal.getSignal()==NmSignal.SHORT) {
				m_beginTimeTag = inputTag;
			}
		} else {
			// ^C}[NĂ
			if (m_endTimeTag==null) {
				// ^C}[IĂȂ
				if (m_beginTimeTag.calcTimeDifference(inputTag)>=m_timerMinute*60) {
					m_endTimeTag = inputTag;
					returnValue = new JudgmentResult(inputTag, getDefaultSignal());
				}
			} else {
				// ^C}[IĂ
				returnValue = new JudgmentResult(inputTag, getDefaultSignal());
			}
		}
		setDetails("[" + getLabel() + "]" + returnValue.getSignal().toString());
		return returnValue;
	}
	
}
