/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * MACDC
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class MacdLine extends IndexLine {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * ZEMAC
	 * 
	 * @since 1.00
	 */
	private final EmaLine m_shortTermEmaLine;

	/**
	 * EMAC
	 * 
	 * @since 1.00
	 */
	private final EmaLine m_longTermEmaLine;
	
	/**
	 * MacdLine𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_pcountShortTermEma ZEMAZô߂Ɏg|Cg
	 * @param p_pcountLongTermEma EMAZô߂Ɏg|Cg
	 */
	public MacdLine(int p_pcountShortTermEma, int p_pcountLongTermEma) {
		m_shortTermEmaLine = new EmaLine(p_pcountShortTermEma, p_pcountLongTermEma);
		m_longTermEmaLine = new EmaLine(p_pcountLongTermEma, p_pcountLongTermEma);
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObjectList#remove(java.lang.String)
	 */
	@Override
	public void remove(String p_date) {
		super.remove(p_date);
		m_shortTermEmaLine.remove(p_date);
		m_longTermEmaLine.remove(p_date);
	}

	/**
	 * \[XCMACDZoăXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 */
	public void addObject(IndexLine p_src) {
		// TCY`FbN
		if (p_src==null) return;
		if (p_src.size()<=0) return; 
		// MACDǉ
		m_shortTermEmaLine.addPoint(p_src);
		m_longTermEmaLine.addPoint(p_src);
		// EMACTCY`FbN
		if (!m_shortTermEmaLine.isExist()) return;
		if (!m_longTermEmaLine.isExist()) return;
		// _ǉ
		IndexPoint lastPoint = p_src.getLast();
		add(new IndexPoint(lastPoint.getTag(),
				m_shortTermEmaLine.getLast().getValue() - 
				m_longTermEmaLine.getLast().getValue()
			));
	}
	
}
