/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;

import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * VOi{bNXt[[N
 * 
 * @since 2.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public interface SignalBoxFramework {

	/**
	 * ݒlCԂ܂B
	 * 
	 * @since 2.00
	 * @return ݒlC 
	 */
	public SimpleLineStream getCurrent();

	/**
	 * [\NԂ܂B
	 * 
	 * @since 2.00
	 * @return [\N
	 */
	public CandleStickListStream getCandleStick();

	/**
	 * MFE(Maximum Favorable Excursion,ő叇s)
	 * <br>Ōɖ肵|WVMFEłB
	 * 
	 * @since 2.00
	 * @return MFE(Maximum Favorable Excursion,ő叇s)
	 */
	public SimpleLineStream getMfe();

	/**
	 * MAE(Maximum Adverse Excursion,őts)
	 * <br>Ōɖ肵|WVMAEłB
	 * 
	 * @since 2.00
	 * @return MAE(Maximum Adverse Excursion,őts)
	 */
	public SimpleLineStream getMae();

	/**
	 * |WVԂ܂B
	 * 
	 * @since 2.00
	 * @return |WV 
	 */
	public SimpleLineStream getPosition();

	/**
	 * |WVԂ܂B
	 * 
	 * @since 2.60
	 * @return |WV 
	 */
	public SimpleLineStream getLongPosition();

	/**
	 * |WVԂ܂B
	 * 
	 * @since 2.60
	 * @return |WV 
	 */
	public SimpleLineStream getShortPosition();

	/**
	 * h[_EԂ܂B
	 * 
	 * @since 2.30
	 * @return h[_E 
	 */
	public SimpleLineStream getDrawDown();
	
	/**
	 * 茋ʂ̃VOiԂ܂B
	 * 
	 * @since 2.00
	 * @return 茋ʂ̃VOi
	 */
	public SignalBlock getResult();
	
	/**
	 * ێĂeNjJwWf[^폜܂Bw肵t̃f[^폜܂B
	 * 
	 * @since 2.00
	 * @param p_date 폜Ώۓ
	 */
	public void remove(String p_date);

	/**
	 * ێĂeNjJwWf[^CSVo͂܂B
	 * 
	 * @since 2.00
	 * @param p_folder o͐tH_
	 */
	public void writeCsv(String p_folder) throws FileNotFoundException;
	
	/**
	 * ێĂeNjJwWf[^XML\ŕԂ܂B
	 * 
	 * @since 2.02
	 * @return ێĂeNjJwWf[^XML\
	 */
	public String createXml();

	/**
	 * p[^Xg𐶐ĕԂ܂B
	 * 
	 * @since 2.41
	 * @return p[^Xg
	 * @throws GeneListException p[^XgɈُ킪ꍇ
	 */
	public GeneList createDefaultGeneList() throws GeneListException;

	/**
	 * P|WV̑ztsl1
	 * 
	 * @since 2.60
	 * @return P|WV̑ztsl1
	 */
	public IndexLineStream getRisk1();

	/**
	 * P|WV̑ztsl2
	 * 
	 * @since 2.60
	 * @return P|WV̑ztsl2
	 */
	public IndexLineStream getRisk2();

	/**
	 * P̃GgŔ郆jbgԂ܂B
	 * 
	 * @since 2.52
	 * @return P̃GgŔ郆jbg
	 */
	public IndexLineStream getUnitQty();

	/**
	 * eNjJwWCXg[̃XgԂ܂B
	 * 
	 * @since 2.51
	 * @return eNjJwWCXg[̃Xg
	 */
	public ArrayList<IndexLineStream> getIndexLineStreamList();
	
	/**
	 * VOiR|[lg̃XgԂ܂B
	 * 
	 * @since 2.51
	 * @return VOiR|[lg̃Xg
	 */
	public ArrayList<Signal> getSignalList();

	/**
	 * VOi{bNX̃RpC[hԂ܂B
	 * 
	 * @since 2.51
	 * @return VOi{bNX̃RpC[h
	 */
	public NmCompileMode getCompileMode();
	
	/**
	 * Xby[WԂ܂B
	 * 
	 * @since 2.60
	 * @return Xby[W
	 */
	public IndexLineStream getSlippage();

	/**
	 * ʕ\\ȃeNjJwW̃XgԂ܂B
	 * 
	 * @since 2.60
	 * @return ʕ\\ȃeNjJwW̃Xg
	 */
	public HashMap<String, IndexObjectList<?>> getViewList();

	/**
	 * 󋵂̃CԂ܂B
	 * 
	 * @since 2.60
	 * @return 󋵂̃C
	 */
	public SimpleLine getStatusLine();
	
}
