/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;

/**
 *`lドCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("ChannelHighLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class ChannelHighLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * `lドC
	 * 
	 * @since 1.00
	 */
	private final ChannelHighLine m_channelHighLine;
	
	/**
	 * ChannelHighLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_ccountLabel `lドCZô߂Ɏg[\Ñp[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public ChannelHighLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene ccountGene = p_geneList.getGene(p_ccountLabel);
		// `lドC̐
		int cost = ccountGene.getIntValue();
		m_channelHighLine = new ChannelHighLine(cost);
		// eNjJwW̓|[gݒ
		getPortList().add("@CandleStickList",cost);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub()
	 */
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@CandleStickList");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_channelHighLine.addPoint((CandleStickList)port.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		notifyIndexNext();
	}

	/**
	 * `lドCԂ܂B
	 * 
	 * @since 1.00
	 * @return `lドC
	 */
	@Override
	public ChannelHighLine getValues() {
		return m_channelHighLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_channelHighLine.setCapacity(getDestinationMaxCost());
	}
	
}
