/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.IndexPoint;

/**
 * VvCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@EntryPoint
@TypeIndexStream("SimpleLine")
@InputComponentList(values={"@IndexLine"})
public class SimpleLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * VvCiŒ̃f[^j
	 * 
	 * @since 1.00
	 */
	private final SimpleLine m_simpleLine;


	/**
	 * VvCi\pAߋf[^܂ށj
	 * 
	 * @since 3.00
	 */
	private final SimpleLine m_viewSimpleLine;
	
	/**
	 * SimpleLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public SimpleLineStream(String p_label) {
		super(p_label);
		m_simpleLine = new SimpleLine();
		m_viewSimpleLine = new SimpleLine();
		// eNjJwW̓|[gݒ
		getPortList().add("@IndexLine",1);
	}

	/**
	 * Xg[̓
	 * 
	 * @since 3.00
	 * @param p_src \[X|Cg
	 * @return VȃeNjJwW𐶐ꍇtrueԂ܂B
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public boolean enter(IndexPoint p_src) throws IndexStreamException {
		// null`FbN
		if (p_src==null) {
			throw new IndexStreamException("Null Error");
		}
		// |Cgǉ
		m_simpleLine.addPoint(p_src);
		if (m_simpleLine.getCapacity()!=Integer.MAX_VALUE) {
			m_viewSimpleLine.addPoint(p_src);
		}
		// ̃eNjJwWɒʒm
		return notifyIndexNext();
	}
	
	@Override
	public boolean notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@IndexLine");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		IndexLine il = (IndexLine)port.getIndexStream().getValues();
		m_simpleLine.addPoint(il.getLast());
		if (m_simpleLine.getCapacity()!=Integer.MAX_VALUE) {
			m_viewSimpleLine.addPoint(il.getLast());
		}
		// ̃eNjJwWɒʒm
		return notifyIndexNext();
	}

	/**
	 * VvCԂ܂B
	 * 
	 * @since 1.00
	 * @return VvC
	 */
	@Override
	public SimpleLine getValues() {
		return m_simpleLine;
	}	

	@Override
	public SimpleLine getViewValues() {
		if (m_simpleLine.getCapacity()==Integer.MAX_VALUE) {
			// economizeĂȂꍇ͕\p݂Ȃ
			return m_simpleLine;
		} else {
			// economize͕\p݂
			return m_viewSimpleLine;
		}
	}	
	
	@Override
	public void economizeMemory() {
		m_simpleLine.setCapacity(getDestinationMaxCost());
	}

	@Override
	public void economizeMemory(int p_capacity) {
		int capacity = Math.max(p_capacity, getDestinationMaxCost());
		m_simpleLine.setCapacity(capacity);
	}
	
}
