/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.SmaLine;
import jp.robotbrain.signal.IndexLine;

/**
 * SMACXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("SmaLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class SmaLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * SMAC
	 * 
	 * @since 1.00
	 */
	private final SmaLine m_smaLine;
	
	/**
	 * SmaLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_pcountLabel SMAZô߂Ɏg|Cg̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public SmaLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene pcountGene = p_geneList.getGene(p_pcountLabel);
		// SMAC̐
		int cost = pcountGene.getIntValue();
		m_smaLine = new SmaLine(cost);
		// eNjJwW̓|[gݒ
		getPortList().add("@IndexLine",cost);
	}
	
	@Override
	public boolean notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@IndexLine");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_smaLine.addPoint((IndexLine)port.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		return notifyIndexNext();
	}

	/**
	 * SMACԂ܂B
	 * 
	 * @since 1.00
	 * @return SMAC
	 */
	@Override
	public SmaLine getValues() {
		return m_smaLine;
	}

	@Override
	public SmaLine getViewValues() {
		return m_smaLine;
	}
	
	@Override
	public void economizeMemory() {
		m_smaLine.setCapacity(getDestinationMaxCost());
	}

	@Override
	public void economizeMemory(int p_capacity) {
		int capacity = Math.max(p_capacity, getDestinationMaxCost());
		m_smaLine.setCapacity(capacity);
	}
	
}
