/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.robotbrain.common.UtilResource;

/**
 * wWlӂɓ肷L[ł
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Tag implements Serializable,Cloneable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ^O̕
	 * 
	 * @since 1.00
	 */
	private String m_value;

	/**
	 * VXeŏꂽTag𐶐܂B
	 * 
	 * @since 1.00
	 */
	public Tag() {
		m_value = getNowDateTime();
	}
	
	/**
	 * w肵^OŏTag𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^OBuyyyymmdd HH:mm ssv`
	 * uyyyymmdd HH:mmv`Ŏw肵܂Bu/vtł肠܂B
	 */
	public Tag(String p_tag) {
		m_value = p_tag.replace("/", "");
	}
	
	/**
	 * ̃IuWFNg̃Rs[쐬ĕԂ܂B
	 * 
	 * @since 2.01
	 * @return ̃IuWFNg̃Rs[ 
	 */
	@Override
	public Tag clone() {
		Tag returnValue = new Tag(this.m_value);
		return returnValue;
	}
	
	/**
	 * w肳ꂽIuWFNgƓꂩԂ܂B
	 * 
	 * @since 1.00
	 * @param p_other rΏۂ̃IuWFNg
	 * @return w肳ꂽIuWFNgƓłtrueԂ
	 */
	@Override
	public boolean equals(Object p_other) {
		if (p_other==null) return false;
		if (getValue()==null) return false;
		if (p_other instanceof Tag) {
			Tag other = (Tag)p_other;
			return getValue().equals(other.getValue());
		} else {
			return false;
		}
	}

	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 1.00
	 * @return nbVR[h
	 */
	@Override
	public int hashCode() {
		return m_value.hashCode();
	}
	
	/**
	 * VXeŏTagCX^XԂ܂B
	 * 
	 * @since 1.00
	 * @return TagCX^X
	 */
	public static Tag create() {
		return new Tag();
	}

	/**
	 * w肵^OŏTagCX^XԂ܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^OBuyyyymmdd HH:mm ssv`
	 * uyyyymmdd HH:mmv`Ŏw肵܂B
	 * @return TagCX^X
	 * @throws TagFormatException ̃^OɌ肪ꍇ
	 */
	public static Tag create(String p_tag) throws TagFormatException {
		if (!checkTagStringFormat(p_tag)) {
			throw new TagFormatException(UtilResource.getErrMsg("rtl_exception", TagFormatException.class, 0) + p_tag);
		}
		return new Tag(p_tag);
	}
	
	/**
	 * ^Ǒ``FbN
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 * @return `ɖ肪Ȃtrue
	 */
	private static boolean checkTagStringFormat(String p_tag) {
		String tag = p_tag.replace("/", "");
		// uyyyymmdd HH:mm ssv`
		if (tag.length()==17) {
			Pattern p1 = Pattern.compile("([0-9]{8} [0-9]{2}:[0-9]{2} [0-9]{2})");
			Matcher m1 = p1.matcher(tag);
			if (m1.find()) return true;
		}
		if (tag.length()==14) {
			// uyyyymmdd HH:mmv`
			Pattern p2 = Pattern.compile("([0-9]{8} [0-9]{2}:[0-9]{2})");
			Matcher m2 = p2.matcher(tag);
			if (m2.find()) return true;
		}
		return false;
	}

	/**
	 * ݂̓Ԃiyyyymmdd HH:mm ss`j
	 * 
	 * @since 1.00
	 * @return ݂̓iyyyymmdd HH:mm ss`j
	 */
	public static String getNowDateTime() {
		// DateIuWFNg𐶐
		Date date = new Date();
		// SimpleDateFormatCX^X
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("yyyyMMdd HH:mm ss");
		// tH[}bgԂԂ
		return formatter.format(date);
	}
	
	/**
	 * ^O̓t(yyyymmdd)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return t(yyyymmdd)
	 */
	public String getDate() {
		return m_value.substring(0, 8);
	}

	/**
	 * ^O̔N(yyyy)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return N(yyyy)
	 */
	public String getYear() {
		return m_value.substring(0, 4);
	}

	/**
	 * ^Ǒ(MM)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return (MM)
	 */
	public String getMonth() {
		return m_value.substring(4, 6);
	}

	/**
	 * ^O̓(dd)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return (dd)
	 */
	public String getDay() {
		return m_value.substring(6, 8);
	}
	
	/**
	 * ^O̎(HH:mm)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return (HH:mm)
	 */
	public String getTime() {
		return m_value.substring(9, 14);
	}

	/**
	 * ^O̎(HH:mm ss)Ԃ܂B
	 * 
	 * @since 2.41
	 * @return (HH:mm ss)
	 */
	public String getTimeSeconds() {
		return m_value.substring(9);
	}
	
	/**
	 * ^O̎(HH)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return (HH)
	 */
	public int getHour() {
		return Integer.parseInt(m_value.substring(9, 11));
	}
	
	/**
	 * ^O̕(mm)Ԃ܂B
	 * 
	 * @since 1.00
	 * @return (mm)
	 */
	public int getMinutes() {
		return Integer.parseInt(m_value.substring(12, 14));
	}

	/**
	 * ^O̕b(ss)Ԃ܂B
	 * 
	 * @since 1.20
	 * @return b(ss)
	 */
	public int getSecond() {
		if (m_value.length()>14) {
			return Integer.parseInt(m_value.substring(15, 17));
		} else {
			return 0;
		}
	}
	
	/**
	 * ^O̕ݒ肵܂Buyyyymmdd HH:mm ssv`
	 * uyyyymmdd HH:mmv`Őݒ肵܂B
	 * 
	 * @since 2.34
	 * @param p_value ^O̕
	 */
	public void setValue(String p_value) {
		m_value = p_value;
	}
	
	/**
	 * ^O̕Ԃ܂Buyyyymmdd HH:mm ssv`
	 * uyyyymmdd HH:mmv`ŕԂ܂B
	 * 
	 * @since 1.00
	 * @return ^O̕
	 */
	public String getValue() {
		return m_value;
	}

	
	/**
	 * ^O̕Ԃ܂Buyyyy/mm/ddv`B
	 * 
	 * @since 2.80
	 * @return ^O̕
	 */
	public String getFormattedDate() {
		return getYear() + "/" + getMonth() + "/" + getDay();
	}
	
	/**
	 * ^O̓CalendarCX^X𐶐ĕԂ܂B
	 * 
	 * @since 1.10
	 * @return CalendarCX^X
	 */
	public Calendar getCalendar() {
		int year = Integer.parseInt(getYear());
        int month = Integer.parseInt(getMonth()) - 1;
        int date = Integer.parseInt(getDay());
        int hourOfDay = getHour();
        int minute = getMinutes();
        int second = getSecond();
		Calendar returnValue = Calendar.getInstance();
		returnValue.set(year, month, date, hourOfDay, minute, second);
		return returnValue;
	}
	
	/**
	 * ^O̎̎Ɣr܂B
	 * 
	 * @since 1.00
	 * @param p_time  hh:mm`
	 * @return ^O̕傫ꍇ1Aꍇ-1Aꍇ0
	 * @throws TagFormatException ̎Ɍ肪ꍇ
	 */
	public int compareTime(String p_time) throws TagFormatException {
		// `FbN
		if (p_time.length()!=5) throw new TagFormatException(UtilResource.getErrMsg("rtl_exception", TagFormatException.class, 1) + p_time);
		try {
			int hour = Integer.parseInt(p_time.substring(0, 2));
			int min = Integer.parseInt(p_time.substring(3, 5));
			// r
			if (getHour()>hour) {
				return 1;
			} else if (getHour()<hour) {
				return -1;
			} else {
				if (getMinutes()>min) {
					return 1;
				} else if (getMinutes()<min) {
					return -1;
				} else {
					return 0;
				}
			}
		} catch (NumberFormatException e) {
			throw new TagFormatException(UtilResource.getErrMsg("rtl_exception", TagFormatException.class, 1) + p_time);
		}
	}

	/**
	 * Q̃^O̎ԍbŕԂ܂
	 * 
	 * @since 2.05
	 * @param p_other rΏۃ^O
	 * @return ԍ̐Βlibj
	 */
	public long calcTimeDifference(Tag p_other) {
		Calendar a = this.getCalendar();
		Calendar b = p_other.getCalendar();
		return Math.abs(a.getTimeInMillis() - b.getTimeInMillis()) / 1000;
	}
	
}
