/**
 * Copyright (C) 2012-2013 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.ui.graph;

import java.awt.Color;

import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.UtilSignal;

/**
 * Ot̃C
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphLayer {

	/**
	 * C
	 * 
	 * @since 2.60
	 */
	private final String m_name;

	/**
	 * CԍB
	 * ̃eNjJwW𓯂Cɏd˂ĕ\ꍇ͓lZbgB
	 * XgœCԍꍇɏdˍ킹ĕ`悳B
	 * 
	 * @since 2.80
	 */
	private final int m_layerNo;

	/**
	 * _ȉ̌
	 * 
	 * @since 2.60
	 */
	private final int m_indexScale;

	/**
	 * ڐ
	 * 
	 * @since 2.60
	 */
	private GraphRuler m_ruler;

	/**
	 * ^Cgo[ɕ\镶
	 * 
	 * @since 2.60
	 */
	private String m_title;
	
	/**
	 * Ot\eNjJwW
	 * 
	 * @since 2.60
	 */
	private IndexObjectList<?> m_paintSrcList;

	/**
	 * Ot\eNjJwW̍ől
	 * 
	 * @since 2.60
	 */
	private double m_max;

	/**
	 * Ot\eNjJwW̍ŏl
	 * 
	 * @since 2.60
	 */
	private double m_min;

	/**
	 * plɂ郌C̍䗦(1`100)
	 * 
	 * @since 2.60
	 */
	private int m_heightRatio;

	/**
	 * Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgj
	 * 
	 * @since 2.60
	 */
	private Tag m_prevTag;

	/**
	 * eNjJwW`悷FB[\N̏ꍇ͘gqQ̐̕FB
	 * 
	 * @since 2.60
	 */
	private Color m_foreColor;

	/**
	 * ڍ׏̐FƓFŕ`悷邩B
	 * |WV̎ށiAjŐFꍇɎgpB
	 * 
	 * @since 2.60
	 */
	private boolean m_statusColor;

	/* yeTCY̐z
	---------------------------------------------------------------------  GraphPanel̏[
	                                                                                         
	                              m_top                getTitleBarTop()  getIndexTop()
	-------------------------------  C̏[                       
	                              } m_titleBarTopOffset                   
	-------------------------                                          
	25ړ              m_titleBarHeight                        
	-------------------------                                         
	                              } m_indexTopOffset                         
	       ....         .....
	      .    .    ....
	     .      ....
	    .
	                              } m_indexBottomOffset
	-------------------------------
	*/

	/**
	 * C̏[YW
	 * 
	 * @since 2.60
	 */
	private int m_top;

	/**
	 * C̏[^Cgo[[܂ł̋
	 * 
	 * @since 2.60
	 */
	private final int m_titleBarTopOffset;

	/**
	 * ^Cgo[̍
	 * 
	 * @since 2.60
	 */
	private int m_titleBarHeight;

	/**
	 * ^Cgo[̉[eNjJwW`GA[܂ł̋
	 * 
	 * @since 2.60
	 */
	private int m_indexTopOffset;

	/**
	 * C̉[eNjJwW`GA[܂ł̋
	 * 
	 * @since 2.80
	 */
	private final int m_indexBottomOffset;

	/**
	 * CԍŖڐ̓Ƃꍇtrue
	 * 
	 * @since 2.60
	 */
	private boolean m_syncRuler;

	/**
	 * CC̏ꍇtrue
	 * 
	 * @since 2.80
	 */
	private final boolean m_mainLayer;
	
	/**
	 * eR|[lg̃plւ̎Q
	 * 
	 * @since 2.80
	 */
	private final GraphPanel m_parent;
	
	/**
	 * \ÕeNjJwW̌f[^
	 * 
	 * @since 2.80
	 */
	private final IndexObjectList<?> m_srcList;

	/**
	 * ڐʂ̂悻ŕ`悷邩w肵܂
	 * 
	 * @since 2.80
	 */
	private final int m_divCount;
	
	/**
	 * GraphLayer𐶐܂B
	 * 
	 * @since 2.60
	 * @param p_parent eGraphPanel̃CX^X
	 * @param p_name C
	 * @param p_mainLayer CC̏ꍇtrue
	 * @param p_srcList `悷eNjJwW
	 * @param p_layerNo Cԍ 
	 * @param p_divCount ڐʂ̂悻ŕ`悷邩w肵܂
	 * @param p_titleBarTopOffset C̏[^Cgo[[܂ł̋
	 * @param p_indexBottomOffset C̉[eNjJwW`GA[܂ł̋
	 * @throws GraphException CŃG[ꍇ
	 */
	protected GraphLayer(GraphPanel p_parent, String p_name, boolean p_mainLayer, IndexObjectList<?> p_srcList,
			int p_layerNo, int p_divCount, int p_titleBarTopOffset, int p_indexBottomOffset) throws GraphException {
		m_name = p_name;
		m_heightRatio = 100;
		m_layerNo = p_layerNo;
		m_titleBarTopOffset = p_titleBarTopOffset;
		m_foreColor = Color.BLACK;
		m_title = "";
		m_syncRuler = false;
		m_mainLayer = p_mainLayer;
		m_parent = p_parent;
		m_divCount = p_divCount;
		m_indexBottomOffset = p_indexBottomOffset;
		// Qȏ̓_ȂƐЂȂ
		if (p_srcList==null) {
			throw new GraphException("SrcLine is Null: " + p_name);
		}
		if (p_srcList.size()<2) {
			throw new GraphException("Few SrcLine Values: " + p_name);
		}
		m_srcList = p_srcList;
		m_indexScale = UtilSignal.maxScale(m_srcList);
		// C̏
		init();
	}
	
	/**
	 * C̏Bpl̉`łwWZoB
	 * 
	 * @since 2.80
	 * @throws GraphException C̏Ɏsꍇ
	 */
	protected void init() throws GraphException {
		if (m_mainLayer) {
			// CC̏ꍇ
			initMainLayer();
		} else {
			// TuC̏ꍇ
			initSubLayer();
		}
		// [[̏
		initRuler();
	}
	
	/**
	 * [[܂B
	 * 
	 * @since 2.80
	 */
	protected void initRuler() {
		m_ruler = new GraphRuler(this);
	}
	
	/**
	 * CCp̏Bpl̉`łwWZoB
	 * 
	 * @since 2.60
	 */
	private void initMainLayer() {
		// ʂɕ\\ȃeNjJwWZo
		int viewPointCount = m_parent.getWidthPointCount();
		if (viewPointCount > m_srcList.size()) {
			viewPointCount = m_srcList.size();
		}
		// őlAŏlA\[XCZbg
		if (m_srcList instanceof CandleStickList) {
			CandleStickList src = (CandleStickList)m_srcList;
			CandleStickList srcTail = src.getTailList(viewPointCount);
			if (m_srcList.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax();
				m_min = srcTail.getMin();
			}
			m_paintSrcList = srcTail;
		} else if (m_srcList instanceof IndexLine) {
			IndexLine src = (IndexLine)m_srcList;
    		IndexLine srcTail = src.getTailLine(viewPointCount);
			if (m_srcList.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax().getValue();
				m_min = srcTail.getMin().getValue();
			}
			m_paintSrcList = srcTail;
		} else {
			m_max = 0D;
			m_min = 0D;
    		m_paintSrcList = m_srcList;
		}
	}

	/**
	 * TuCp̏BCC̃eNjJwWƓԂ`ΏۂƂB
	 * 
	 * @since 2.60
	 */
	private void initSubLayer() throws GraphException {
		// CC`͈͂̊Jn^O擾
		if (m_parent.getMainLayer()==null) throw new GraphException("Not Found MainLayer");
		if (m_parent.getMainLayer().getPaintSrcList().size()<=0) throw new GraphException("Not Found MainLayer");
		IndexObject idx = m_parent.getMainLayer().getPaintSrcList().get(0);
		// őlAŏlA\[XCZbg
		if (m_srcList instanceof CandleStickList) {
			CandleStickList src = (CandleStickList)m_srcList;
			CandleStickList srcTail = src.getTailList(idx.getTag());
			if (m_srcList.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax();
				m_min = srcTail.getMin();
			}
			m_paintSrcList = srcTail;
		} else if (m_srcList instanceof IndexLine) {
			IndexLine src = (IndexLine)m_srcList;
    		IndexLine srcTail = src.getTailLine(idx.getTag());
			if (m_srcList.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax().getValue();
				m_min = srcTail.getMin().getValue();
			}
			m_paintSrcList = srcTail;
		} else {
			m_max = 0D;
			m_min = 0D;
    		m_paintSrcList = m_srcList;
		}
	}
	
	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 2.60
	 * @return nbVR[h
	 */
	@Override
	public int hashCode() {
		return m_name.hashCode();
	}

	/**
	 * w肵CƓꍇtrueԂ܂B
	 * ꂩǂ̓CŔ肵܂B
	 * 
	 * @since 2.60
	 * @param p_other Ώۂ̃C
	 */
	@Override
	public boolean equals(Object p_other) {
		if (!(p_other instanceof GraphLayer)) return false;
		GraphLayer other = (GraphLayer)p_other;
		if (this.m_name.equals(other.getName())) {
			return true;
		}
		return false;
	}

	/**
	 * CԂ܂B
	 * 
	 * @since 2.60
	 * @return C
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * Ot\eNjJwW̍őlԂ܂B
	 * 
	 * @since 2.60
	 * @return Ot\eNjJwW̍ől
	 */
	protected double getMax() {
		return m_max;
	}

	/**
	 * Ot\eNjJwW̍őlݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_max Ot\eNjJwW̍ől
	 */
	protected void setMax(double p_max) {
		m_max = p_max;
	}

	/**
	 * Ot\eNjJwW̍ŏlԂ܂B
	 * 
	 * @since 2.60
	 * @return Ot\eNjJwW̍ŏl
	 */
	protected double getMin() {
		return m_min;
	}

	/**
	 * Ot\eNjJwW̍ŏlݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_min Ot\eNjJwW̍ŏl
	 */
	protected void setMin(double p_min) {
		m_min = p_min;
	}

	/**
	 * Ot\eNjJwWԂ܂B
	 * 
	 * @since 2.60
	 * @return Ot\eNjJwW
	 */
	public IndexObjectList<?> getPaintSrcList() {
		return m_paintSrcList;
	}

	/**
	 * wWƎwW`GA̍̔䗦Ԃ܂B
	 * 
	 * @since 2.60
	 * @param p_panelHeight pl̍
	 * @return wWƎwW`GA̍̔䗦
	 */
	private double getRatio(int p_panelHeight) {
		// wW`GA̍Zo
		double indexViewHeight = (p_panelHeight * m_heightRatio / 100) - (m_titleBarTopOffset + m_titleBarHeight + m_indexTopOffset + m_indexBottomOffset);
    	// wWl̕ϓZo
		double srcLineRange = m_max - m_min;
		// wWƎwW`GA̍̔䗦Ԃ
		return indexViewHeight / srcLineRange;
    }

	/**
	 * C̏[YWݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_top C̏[YW
	 */
	protected void setTop(int p_top) {
		m_top = p_top;
	}

	/**
	 * C̏[YWԂ܂B
	 * 
	 * @since 2.60
	 * @return C̏[YW
	 */
	protected int getTop() {
		return m_top;
	}

	/**
	 * ^Cgo[̏[YWԂ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̏[YW
	 */
	public int getTitleBarTop() {
		return m_top + m_titleBarTopOffset;
	}

	/**
	 * eNjJwW`GA[YWԂ܂B
	 * 
	 * @since 2.60
	 * @return eNjJwW`GA[YW
	 */
	public int getIndexTop() {
		return getTitleBarTop() + m_titleBarHeight + m_indexTopOffset;
	}

	/**
	 * Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgjݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_prevTag Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgj
	 */
	protected void setPrevTag(Tag p_prevTag) {
		m_prevTag = p_prevTag;
	}

	/**
	 * Oɕ`悵wW̃^OieNjJwW`悷鎞ɎgjԂ܂B
	 * 
	 * @since 2.60
	 * @return Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgj
	 */
	protected Tag getPrevTag() {
		return m_prevTag;
	}

	/**
	 * w肵eNjJwWlYWZoB
	 * 
	 * @since 2.60
	 * @param p_value eNjJwWl
	 * @param p_panelHeight pl̍
	 * @return w肵eNjJwWlɑ΂YW
	 */
	protected int calcY(double p_value, int p_panelHeight) {
		return ((int)((getMax()-p_value) * getRatio(p_panelHeight))) + getIndexTop();
	}

	/**
	 * w肵eNjJwWl̕YW̕ɕϊB
	 * 
	 * @since 2.60
	 * @param p_distance eNjJwWl̕
	 * @param p_panelHeight pl̍
	 * @return w肵eNjJwWl̕ɑ΂YW̕
	 */
	protected int calcYDistance(double p_distance, int p_panelHeight) {
		return (int)(p_distance * getRatio(p_panelHeight));
	}

	/**
	 * _ȉ̌Ԃ܂B
	 * 
	 * @since 2.60
	 * @return _ȉ̌
	 */
	public int getIndexScale() {
		return m_indexScale;
	}

	/**
	 * CԍԂ܂B
	 * ̃eNjJwW𓯂Cɏd˂ĕ\ꍇ͓lԂ܂B
	 * XgœCԍꍇɏdˍ킹ĕ`悳܂B
	 * GraphLayerListœCԍAĂKv܂B
	 * 
	 * @since 2.60
	 * @return Cԍ
	 */
	public int getLayerNo() {
		return m_layerNo;
	}

	/**
	 * ^Cgo[̍Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̍
	 */
	public int getTitleBarHeight() {
		return m_titleBarHeight;
	}

	/**
	 * ^Cgo[̍ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarHeight ^Cgo[̍
	 */
	public void setTitleBarHeight(int p_titleBarHeight) {
		m_titleBarHeight = p_titleBarHeight;
	}

	/**
	 * C̏[^Cgo[[܂ł̋Ԃ܂B
	 * 
	 * @since 2.60
	 * @return C̏[^Cgo[[܂ł̋
	 */
	protected int getTitleBarTopOffset() {
		return m_titleBarTopOffset;
	}

	/**
	 * ^Cgo[̉[eNjJwW`GA[܂ł̗]Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̉[eNjJwW`GA[܂ł̗]
	 */
	protected int getIndexTopOffset() {
		return m_indexTopOffset;
	}

	/**
	 * ^Cgo[̉[eNjJwW`GA[܂ł̗]ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_indexTopOffset ^Cgo[̉[eNjJwW`GA[܂ł̗]
	 */
	protected void setIndexTopOffset(int p_indexTopOffset) {
		m_indexTopOffset = p_indexTopOffset;
	}

	/**
	 * eNjJwW`悷FԂ܂B
	 * [\N̏ꍇ͘gqQ̐̕FB
	 * 
	 * @since 2.60
	 * @return eNjJwW`悷F
	 */
	public Color getForeColor() {
		return m_foreColor;
	}

	/**
	 * eNjJwW`悷Fݒ肵܂B
	 * [\N̏ꍇ͘gqQ̐̕FB
	 * 
	 * @since 2.60
	 * @param p_foreColor eNjJwW`悷F
	 */
	public void setForeColor(Color p_foreColor) {
		m_foreColor = p_foreColor;
	}

	/**
	 * eNjJwW̐̐F|WV̎ށiAjŐFꍇtrueԂ܂B
	 * 
	 * @since 2.60
	 * @return eNjJwW̐̐F|WV̎ށiAjŐFꍇtrue
	 */
	public boolean isStatusColor() {
		return m_statusColor;
	}

	/**
	 * eNjJwW̐̐F|WV̎ށiAjŐFꍇtrueݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_statusColor eNjJwW̐̐F|WV̎ށiAjŐFꍇtrue
	 */
	public void setStatusColor(boolean p_statusColor) {
		m_statusColor = p_statusColor;
	}

	/**
	 * plɂ郌C̍䗦(1`100)Ԃ܂B
	 * pl̒ŃC%߂邩܂B
	 * 
	 * @since 2.60
	 * @return plɂ郌C̍䗦(1`100)
	 */
	protected int getHeightRatio() {
		return m_heightRatio;
	}
	
	/**
	 * plɂ郌C̍䗦(1`100)ݒ肵܂B
	 * pl̒ŃC%߂邩܂B
	 * 
	 * @since 2.60
	 * @param p_heightRatio plɂ郌C̍䗦(1`100)
	 */
	protected void setHeightRatio(int p_heightRatio) {
		m_heightRatio = p_heightRatio;
	}

	/**
	 * ڐԂ܂B
	 * 
	 * @since 2.60
	 * @return ڐ
	 */
	protected GraphRuler getRuler() {
		return m_ruler;
	}

	/**
	 * ^Cgo[ɕ\镶Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[ɕ\镶
	 */
	public String getTitle() {
		return m_title;
	}

	/**
	 * ^Cgo[ɕ\镶ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_title ^Cgo[ɕ\镶
	 */
	public void setTitle(String p_title) {
		m_title = p_title;
	}

	/**
	 * CԍŖڐ̓ƂꍇtrueԂ܂B
	 * 
	 * @since 2.60
	 * @return CԍŖڐ̓Ƃꍇtrue
	 */
	public boolean isSyncRuler() {
		return m_syncRuler;
	}

	/**
	 * CԍŖڐ̓Ƃꍇtrueݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_syncRuler CԍŖڐ̓Ƃꍇtrue
	 */
	public void setSyncRuler(boolean p_syncRuler) {
		m_syncRuler = p_syncRuler;
	}

	/**
	 * ڐʂ̂悻ŕ`悷邩w肵܂
	 * 
	 * @since 2.80
	 * @return ڐʂ̂悻ŕ`悷邩
	 */
	protected int getDivCount() {
		return m_divCount;
	}

	/**
	 * CC̏ꍇtrueԂ܂B
	 * 
	 * @since 2.80
	 * @return CC̏ꍇtrue
	 */
	public boolean isMainLayer() {
		return m_mainLayer;
	}

}
