
resources :glossary, :only => [:show, :edit, :update, :destroy]
resources :term_categories, :only => [:show, :edit, :update, :destroy]

match '/projects/:project_id/glossary/new/preview', :to => 'glossary#preview', :as => 'glossary_new_preview', :via => [:get, :post, :put]
match '/glossary/edit/:id/preview', :to => 'glossary#preview', :as => 'glossary_edit_preview', :via => [:get, :post, :put]

match '/glossary_styles/edit', :to => 'glossary_styles#edit'
match '/glossary_styles/search', :to => 'glossary_styles#search'

resources :projects do
  resources :glossary, :except => [:show, :edit, :update, :destroy] do
    collection do
      get :index_clear
      get :add_term_category
      get :move_all
      get :import_csv
      get :import_csv_exec
    end
  end
  resources :term_categories, :except => [:show, :edit, :update, :destroy]
  resources :glossary_styles, :except => [:show, :edit, :update, :destroy]
end


