/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ObjectId;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.util.SimplePool;
import com.mongodb.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class GridFSInputFile
extends GridFSFile {
    final InputStream _in;
    boolean _saved = false;
    static SimplePool<MessageDigest> _md5Pool = new SimplePool("md5", 10, -1, false, false){

        protected MessageDigest createNew() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("your system doesn't have md5!");
            }
        }
    };

    GridFSInputFile(GridFS fs, InputStream in, String filename) {
        this._fs = fs;
        this._in = in;
        this._filename = filename;
        this._id = new ObjectId();
        this._chunkSize = 262144L;
        this._uploadDate = new Date();
    }

    public DBObject getMetaData() {
        if (this._metadata == null) {
            this._metadata = new BasicDBObject();
        }
        return this._metadata;
    }

    public void setFilename(String fn) {
        this._filename = fn;
    }

    public void setContentType(String ct) {
        this._contentType = ct;
    }

    public void save() {
        if (!this._saved) {
            try {
                this.saveChunks();
            }
            catch (IOException ioe) {
                throw new MongoException("couldn't save chunks", ioe);
            }
        }
        super.save();
    }

    public int saveChunks() throws IOException {
        int start;
        if (this._saved) {
            throw new RuntimeException("already saved!");
        }
        byte[] b = new byte[262144];
        long total = 0L;
        int cn = 0;
        MessageDigest md = _md5Pool.get();
        md.reset();
        DigestInputStream in = new DigestInputStream(this._in, md);
        do {
            int r;
            for (start = 0; start < b.length; start += r) {
                r = in.read(b, start, b.length - start);
                if (r == 0) {
                    throw new RuntimeException("i'm doing something wrong");
                }
                if (r < 0) break;
            }
            total += (long)start;
            byte[] mine = b;
            if (start != b.length) {
                mine = new byte[start];
                System.arraycopy(b, 0, mine, 0, start);
            }
            DBObject chunk = BasicDBObjectBuilder.start().add("files_id", this._id).add("n", cn++).add("data", mine).get();
            this._fs._chunkCollection.save(chunk);
        } while (start >= b.length);
        this._md5 = Util.toHex(md.digest());
        _md5Pool.done(md);
        this._length = total;
        this._saved = true;
        return cn;
    }
}

