<!-- 

Copyright 2009, XBRL International Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

The purpose of this stylesheet is to remove (well, reduce) the chance of
     mode collisions with the iXBRL processor code that imports it.
-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:out="http://www.w3.org/1999/XSL/TransformAlias">

  <xsl:namespace-alias stylesheet-prefix="out" result-prefix="xsl"/>

  <xsl:variable name="default-mode-name" select="'ixbrl-schematron-main'"/>

  <!-- Don't allow use of the default mode; rename it -->
  <xsl:template mode="add-atts" match="xsl:template[@match and not(@mode)]
                                     | xsl:apply-templates[not(@mode)]">
    <xsl:attribute name="mode">
      <xsl:value-of select="$default-mode-name"/>
    </xsl:attribute>
  </xsl:template>

  <!-- Make sure that our new mode name effectively acts as the default mode -->
  <xsl:template mode="append" match="/xsl:stylesheet
                                   | /xsl:transform">
    <out:template match="/">
      <out:apply-templates mode="{$default-mode-name}" select="."/>
    </out:template>
  </xsl:template>

  <!-- Remove unnecessary @* (when context node is a document node), just to suppress
       Saxon warning messages -->
  <xsl:template match="@select[. = '@*|*']
                              [ancestor::xsl:template/@match = '/' and not(ancestor::xsl:for-each)]">
    <xsl:attribute name="select">*</xsl:attribute>
  </xsl:template>


  <!-- For everything else, just copy as is -->
  <xsl:template match="@* | node()">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates mode="add-atts" select="."/>
      <xsl:apply-templates/>
      <xsl:apply-templates mode="append" select="."/>
    </xsl:copy>
  </xsl:template>

          <!-- By default, don't add attributes or append content -->
          <xsl:template mode="append" match="*"/>
          <xsl:template mode="add-atts" match="*"/>

</xsl:stylesheet>
