
# MSN ファイナンスの株価データページから財務諸表の情報を得る。
#  usage: ruby finance05.rb company_code
#
# 2009-09-12 katoy
# 2009-09-13 katoy

require 'rubygems'
require 'open-uri'
require 'pp'
require 'benchmark'

require 'Msn_finance'

$KCODE = "utf8"
COMPAMYLIST_PATH = 'data/00-companylist.yaml'

companylist = {}
puts Benchmark.measure { 
  Dir.glob('data/[1-9]*.yaml').each do |f|
    info = Msn_finance.load_yaml("JP:#{File.basename(f, '.yaml')}")
    companylist[info.company[3 .. -1]] = info.name
  end

  open(COMPAMYLIST_PATH, "w") { |f|
    f.write companylist.ya2yaml
  }

  File.open(COMPAMYLIST_PATH, "r") { |io|
    YAML.load_documents(io) do |y|
      # pp y
      pp y.size
    end
  }

}
