
# yahoo ファイナンスの株価データページから株価を得る。
# 今日から過去 count_day 日分のデータを取得して、グラフをつくる。(省略した場合は 20日)
#  usage: ruby finance.rb [count_day]   
#
# 2009-09-12 katoy

require 'rubygems'
require 'Yahoo_finance'
require 'benchmark'
require 'pp'

$KCODE = "utf8"


puts Benchmark.measure {  

  Dir.glob('charts/[1-9]*.yaml').each do |f|
    company = File.basename(f, '.yaml')
    info = Yahoo_finance.load_yaml(company)
    old_size = info.data.size
    info.update
    info.save_yaml(:verify => true)

    pp "#{company} #{info.data.size - old_size}"
  end
}
