#-*- coding: utf-8; -*-

require 'lib/mastermind'
require 'pp'

#0=Black, 1=Cyan, 2=Green, 3=Red, 4=Yellow, 5=White

describe "Random number generator" do

  before do
    @random_generator = Mastermind::RandomGenerator.new
  end

  it "should never generate outside of 0..5 bounds" do
    times_count = 1000
    times_count.times do
      number = @random_generator.next
      number.should be_kind_of Numeric
      number.should satisfy {|n| n >= 0}
      number.should satisfy {|n| n < 6}
    end
  end

  it "should generate an even distribution" do
    buckets = [0, 0, 0, 0, 0, 0]
    times_count = 10000
    times_count.times {buckets[@random_generator.next] += 1}
    (0..5).each do |each|
      buckets[each].should satisfy {|n| n > times_count/6 - times_count/60}
      buckets[each].should satisfy {|n| n < times_count/6 + times_count/60}
    end
  end

end
