/*!
 * Ext JS Library 3.2.0
 * Copyright(c) 2006-2010 Ext JS, Inc.
 * licensing@extjs.com
 * http://www.extjs.com/license
 */
// style_swither の部分は ext3.2 の example 下の styleswither.js から copy し、
// background image 処理を追加した。

function setActiveStyleSheet(title) {
    var i,
    a,
    links = document.getElementsByTagName("link"),
    len = links.length;
    for (i = 0; i < len; i++) {
        a = links[i];
        if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
            a.disabled = true;
            if (a.getAttribute("title") == title) a.disabled = false;
        }
    }
}

function getActiveStyleSheet() {
    var i,
    a,
    links = document.getElementsByTagName("link"),
    len = links.length;
    for (i = 0; i < len; i++) {
        a = links[i];
        if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) {
            return a.getAttribute("title");
        }
    }
    return null;
}

function getPreferredStyleSheet() {
    var i,
    a,
    links = document.getElementsByTagName("link"),
    len = links.length;
    for (i = 0; i < len; i++) {
        a = links[i];
        if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("rel").indexOf("alt") == -1 && a.getAttribute("title")) {
            return a.getAttribute("title");
        }
    }
    return null;
}

function createCookie(name, value, days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        var expires = "; expires=" + date.toGMTString();
    } else {
        expires = "";
    }
    document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name) {
    var nameEQ = name + "=",
    ca = document.cookie.split(';'),
    i,
    c,
    len = ca.length;
    for ( i = 0; i < len; i++) {
        c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1, c.length);
        }
        if (c.indexOf(nameEQ) == 0) {
            return c.substring(nameEQ.length, c.length);
        }
    }
    return null;
}
// ---------------------------------
function setActiveBgImage(val) {
    a = document.getElementById('root_body');
    if (a) {
        if (val != 'undefined') {
            document.getElementById('root_body').style.backgroundImage='url("'+ val +'")'
        } else {
            document.getElementById('root_body').style.babackgroundImage='';
        }
    }
}

function getActiveBgImage() {
    return Ext.get('bgimageswitcher_select').dom.value
}

function getPreferredBgImage() {
    return 'undefined'
}

window.onload = function (e) {
    var cookie = readCookie("style");
    title = cookie ? cookie : getPreferredStyleSheet();
    setActiveStyleSheet(title);

    cookie = readCookie('bgimage');
    title = cookie ? cookie : getPreferredBgImage();
    setActiveBgImage(title);
}

window.onunload = function (e) {
    var title = getActiveStyleSheet();
    createCookie("style", title, 365);

    title = getActiveBgImage();
    createCookie('bgimage', title, 365);
}
//
//var cookie = readCookie("style");
//var title = cookie ? cookie : getPreferredStyleSheet();
//setActiveStyleSheet(title);
//
//cookie = readCookie('bgimage');
//title = cookie ? cookie : getPreferredBgImage();
//setActiveBgImage(title);
