/**
 * 横反転のエフェクト.
 * @param {Image} face 表面イメージ.
 * @param {mage} back 裏面イメージ.
 * @param {int} cx 反転中心 x座標.
 * @param {int} cy 反転中心 y座標.
 */
function turn(face, back, cx, cy) {
    var speed = 800;
    face.animate({
        scale: '0 1 ' + cx + ' ' + cy
    }, speed / 2, '<', after);
    function after() {
        face.attr({
            opacity: 0
        });
        back.attr({
            opacity: 1
        });
        back.scale(0.1, 1, cx, cy);
        back.show();
        back.animate({
            scale: '1 1 ' + cx + ' ' + cy
        }, speed / 2, '>');
    }
}

/**
 * 回転しながら反転のエフェクト.
 * @param {Image} face 表面イメージ.
 * @param {mage} back 裏面イメージ.
 * @param {int} cx 反転中心 x座標.
 * @param {int} cy 反転中心 y座標.
 */
function rotate(face, back, cx, cy) {
    var speed = 800;
    face.animate({
        rotation: '180 ' + cx + ' ' + cy
    }, speed / 2, '<', after);
    face.rotate(0, cx, cy);
    back.rotate(0, cx, cy);

    function after() {
        face.attr({
            opacity: 0
        });
        back.attr({
            opacity: 1
        });
        back.show();
        back.animate({
            rotation: '180 ' + cx + ' ' + cy
        }, speed / 2, '>');
    }
}

var myDeck;
/**
 *
 */
window.onload = function() {

    var PAPER_X = 1000;
    var PAPER_Y = 600;

    var paper = new Raphael(document.getElementById('canvas_container'),
        PAPER_X, PAPER_Y);

    myDeck = new Deck(paper);

    // paper.canvas.setAttribute('viewBox', '100 100 100 100');
    paper.safari();
};

function show_flat() {
    for (var s = 0; s < Deck.Suits.length; s++) {
        for (var i = 0; i < Deck.Ranks.length; i++) {
            var cardname = Deck.Suits[s] + Deck.Ranks[i];
            var card = myDeck.getCardByName(cardname);
            card.moveTo(i * 76, s * 100);
        }
    }
}

//var handsX = {
//    N: ['DA', 'DT', 'D5', 'D4', 'CQ', 'CJ', 'CT', 'C7', 'C2', 'H7', 'H5', 'H3', 'S5'],
//    E: ['DK', 'DQ', 'D6', 'CA', 'C9', 'C6', 'C5', 'HK', 'HJ', 'H8', 'SJ', 'ST', 'S4'],
//    S: ['DJ', 'D8', 'D7', 'D3', 'D2', 'C8', 'C4', 'C3', 'HT', 'H4', 'SA', 'S9', 'S3'],
//    W: ['D9', 'CK', 'HA', 'HQ', 'H9', 'H6', 'H2', 'SK', 'SQ', 'S8', 'S7', 'S6', 'S2']
//};

//function show_handX() {
//    var pos = ['N', 'E', 'S', 'W'];
//    var xpos = [300, 600, 300, 0];
//    var ypos = [0, 120, 240, 120];
//
//    for (var p = 0; p < pos.length; p++) {
//        for (var i = 0; i < hands[pos[p]].length; i++) {
//            var name = hands[pos[p]][i];
//            var card = deck.getCardByName(name);
//            card.moveTo(xpos[p] + i * 16, ypos[p]);
//            card.toFront();
//        }
//    }
//}

function make_hands() {
    var hand = {};

    var deck = get_suffled(get_deck());
    hand['N'] = deck.slice(0, 13);
    hand['E'] = deck.slice(13, 26);
    hand['S'] = deck.slice(26, 39);
    hand['W'] = deck.slice(39, 52);
    return hand;

    function get_deck() {
        var ary = [];
        for (var s = 0; s < 4; s++) {
            for (var r = 0; r < 13; r++) {
                ary.push(Deck.Suits[s] + Deck.Ranks[r]);
            }
        }
        return ary;
    }

    function get_suffled(deck) {
        // See http://la.ma.la/blog/diary_200608300350.htm#writebacks
        //     実践JavaScriptで配列をシャッフルする方法リファクタリング
        var len = deck.length;
        var res = [];
        while (len) res.push(deck.splice(Math.floor(Math.random() * len--), 1)[0]);
        return res;
    }
}
function convert_bridge(hand) {
    var pos = ['N', 'E', 'S', 'W'];
    var suits_name = ['S', 'H', 'D', 'C'];

    var handX = {
        N:
        {
            S: [],
            H: [],
            D: [],
            C: []
        },
        E:
        {
            S: [],
            H: [],
            D: [],
            C: []
        },
        S:
        {
            S: [],
            H: [],
            D: [],
            C: []
        },
        W:
        {
            S: [],
            H: [],
            D: [],
            C: []
        }
    };

    for (var p = 0; p < 4; p++) {
        var pname = pos[p];
        var handp = hand[pname];

        for (var c = 0; c < handp.length; c++) {
            var card = handp[c];
            var s = card.charAt(0);
            var r = card.charAt(1);
            handX[pname][s].push(r);
        }
    }
    for (p = 0; p < 4; p++) {
        for (s = 0; s < 4; s++) {
            handX[pos[p]][suits_name[s]].sort(function(a, b) {
                var order = Deck.RankStr;
                return (order.indexOf(b) - order.indexOf(a));
            });
        }
    }
    return handX;
}

function show_hand() {
    var pos_name = ['N', 'E', 'S', 'W'];
    var suits_name = ['S', 'H', 'D', 'C'];
    var pos = [
    // N, E, S, W
    [180, 0], [540, 180], [180, 380], [0, 180]
    ];
    var spos = [
    // N [S, H, D, C, [dx,dy]]
    [[0, 0], [76, 0], [76 * 2, 0], [76 * 3, 0], [0, 18]],
    // E
    [[0, 0], [0, 32], [0, 32 * 2], [0, 32 * 3], [-15, 0]],
    // S
    [[0, 0], [76, 0], [76 * 2, 0], [76 * 3, 0], [0, 18]],
    // W
    [[0, 0], [0, 32], [0, 32 * 2], [0, 32 * 3], [15, 0]]
    ];

    var hands = convert_bridge(make_hands());

    for (var p = 0; p < pos_name.length; p++) {
        for (var s = 0; s < suits_name.length; s++) {
            for (var i = 0; i < hands[pos_name[p]][suits_name[s]].length; i++) {
                var len = hands[pos_name[p]][suits_name[s]].length;
                var name = suits_name[s] + hands[pos_name[p]][suits_name[s]][i];
                var card = myDeck.getCardByName(name);
                var x;
                var y;
                if ((spos[p][4][0] >= 0) && (spos[p][4][1] >= 0)) {
                    x = pos[p][0] + spos[p][s][0] + i * spos[p][4][0];
                    y = pos[p][1] + spos[p][s][1] + i * spos[p][4][1];
                } else {
                    x = pos[p][0] + spos[p][s][0] + (len - i) * spos[p][4][0];
                    y = pos[p][1] + spos[p][s][1] + (len - i) * spos[p][4][1];
                }
                card.moveTo(x, y);
                card.toFront();
            }
        }
    }
}


