
# yahoo ファイナンスの株価データページから株価を得る。   
#
# 2009-09-12 katoy

require 'rubygems'
require 'Yahoo_finance'
require 'benchmark'
require 'pp'

$KCODE = "utf8"

# 企業一覧データを読み込む。                                                                                            
def load_categorylist
  obj = nil
  File.open( "cprofile/categorylist.yaml" ) { |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

puts Benchmark.measure {  
  num = 0
  list = load_categorylist
  list.each do |k,v|
    v[:list].each do |data|
      company = data[0]
      num += 1
      next if File.exists?("charts/#{company}.yaml")

      sleep 10
      info = Yahoo_finance.new(company)
      info.read_data
      info.save_yaml(:verify => true)

      pp "#{num}: #{company} #{info.data.size}"

      #data = info.data
      #start_day, end_day = data[0][0], data[data.size() -1][0]
      #title = "#{start_day} - #{end_day}"
      #flc = info.make_graph(data, {:title => title, :size => "650x400", :show_label => data.size <= 30})

      #pp title
      #puts flc.to_url
    end
  end
}
