
# 株価グラフを閲覧する為の html ファイルを生成する。

require 'rubygems'
require 'erb'
require 'open-uri'
require 'kconv'
require 'ya2yaml'
require 'pp'
require 'benchmark'

$KCODE = 'utf8'

class Table

  @@TEMPLATE_PAGE = ERB.new <<EOS, nil, '-'

<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><%= title %></title>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
        <link rel="stylesheet" href="style.css" type="text/css" />

        <!-- This includes the ImageFlow CSS and JavaScript -->
        <link rel="stylesheet" href="imageflow.packed.css" type="text/css" />
        <script type="text/javascript" src="imageflow.packed.js"></script>

    </head>
    <body>
        <h1><%= title %></h1>

        <!-- This is all the XHTML ImageFlow needs -->
        <div id="myImageFlow" class="imageflow">

<% ids.each do |info| -%>
  <img src='<%= info[0] %>' longdesc='<%= info[0] %>' alt='<%= info[1] %>'/>
<% end -%>

        </div>
    </body>
<html>
EOS

  @@TEMPLATE_INDEX = ERB.new <<EOS, nil, '-'

<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><%= title %></title>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    </head>
    <body>
        <h1><%= title %></h1>

<table border="0">
<% pages.each_with_index do |page, indx| -%>
<%   if indx % 5 == 0 -%>
  <tr>
<%   end -%>
  <td>
      <a href='<%= page[0] %>'><%= page[1] %></a>
  </td>
<%   if indx % 5 == 4 -%>
  </tr>
<%   end -%>
<% end -%>

        </table>
    </body>
<html>
EOS

  # id 別の top ページをつくる
  def get_index_by_range(title)
    pages = []
    1.upto(9).each do |id|
      pages << ["chart-#{id}000.html", "#{(id * 1000).to_s}番台" ]
    end
    @@TEMPLATE_INDEX.result binding
  end

  # id 別のページをつくる
  def get_page_by_range(title, min, max, cid_list, market)
    ids = []
    min.upto(max).each do |id|
      # 存在しているものだけを対象にする
      ids << [chart_url(id, market), "#{id}:#{cid_list[id]}"] if market[id] != nil
    end
    @@TEMPLATE_PAGE.result binding
  end

  # 業種別の top ページをつくる
  def get_index_by_category(title, list, market)
    pages = []
    list.each do |k, v|
      pages << ["chart-t#{v[:cid]}.html", "#{v[:cid]}: #{k}"]
    end
    pages.sort!{|x, y| x[0] <=> y[0]}
    @@TEMPLATE_INDEX.result binding
  end

  # 業種別のページをつくる
  def get_page_by_category(title, vals, market)
    ids = vals.to_a.sort  {|x, y| x[0] <=> y[0]}
    ids.map!{|v| [ chart_url(v[0], market), "#{v[0]}:#{v[1]}"] }
    @@TEMPLATE_PAGE.result binding
  end

end

# 企業一覧データを読み込む。
def load_marketlist
  obj = nil
  File.open( "charts/marketlist.yaml" ) { |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

# 企業一覧データを読み込む。
def load_categorylist
  obj = nil
  File.open( "cprofile/categorylist.yaml" ) { |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

# 企業一覧データから [id => name] の hash を作る
def make_cid_list(list)
  cid_list = {}
  list.each do |k,v|
    v[:list].each do |data|
      cid_list[data[0].to_i] = data[1]
    end
  end
  cid_list
end

# id 別のページ群をつくる
def make_by_id(list, cid_list, market)
  (1..9).each do |i|
    data = Table.new.get_page_by_range("#{i*1000}番台", 
      i * 1000, i * 1000 + 999, cid_list, market)

    File.open("html/chart-#{i}000.html", 'w') { |file|
      file.write(data)
    }
  end

  data = Table.new.get_index_by_range("id 別")
  File.open("html/chart-by-id.html", 'w') { |file|
    file.write(data)
  }
end

# 業種別のページ群をつくる
def make_by_category(list, cid_list, market)
  list.each do |key, val|
    data = Table.new.get_page_by_category(key, val[:list], market)

    File.open("html/chart-t#{val[:cid]}.html", 'w') { |file|
      file.write(data)
    }
  end

  data = Table.new.get_index_by_category("業種別", list, market)
  File.open("html/chart-by-category.html", 'w') { |file|
    file.write(data)
  }
end

def chart_url(id, market)
  # "http://gchart.yahoo.co.jp/z?s=#{id}.#{market[id][0]}&t=5y&q=c&l=off&z=m&p=m65,m130,s&a=v&c="
  "images/charts/#{id}#{market[id][0]}.png"
end

puts Benchmark.measure {
  list = load_categorylist
  market = load_marketlist
  cid_list = make_cid_list(list)

  make_by_id(list, cid_list, market)
  make_by_category(list, cid_list, market)
}
