#-*- coding: utf-8; -*-

# 2008-08-02 katoy
#  SEC で新規公開された XBRl データをダウンロードする。
#
#  ruby 1.8.7 (2008-08-11 patchlevel 72) [i686-darwin9]
#  hpricot (0.6.164)
#  progressbar (0.0.3)
#
# 変更履歴:
#  2009-02-28 企業ページの html 構造の変化へ対応。
#

require 'rubygems'
require 'rss'
require 'pp'
require 'hpricot'        # gem install hpricot
require 'open-uri'
require 'pathname'
require 'progressbar'    # gem install progressbar

# RSS Feed
SEC_RSS = 'http://www.sec.gov/Archives/edgar/xbrlrss.xml'
# Archive Page
SEC_ARCHIVE_URL ='http://www.sec.gov/Archives/edgar/xbrl.html'
# BASE URL
SEC_HOME = 'http://www.sec.gov/'

# SEC の RSS を読んで、企業別データページの URL を取得する。
def read_rss rss_url
  list = { }

  open(rss_url) do | http |
    response = http.read

    # /html/body/div/table[2]/tbody/tr[3]/td[3]/a  // company name
    # /html/body/div/table[2]/tbody/tr[4]/td[2]/a  // [html]
    rss_results = RSS::Parser.parse(response, false)
    rss_results.items.each do | item |
      list[item.title] = {  :link => item.link, :date => item.date }
    end
  end
  list
end

# SEC の企業別データページにある XBRLデータを download する
# ダウンロード中はプログレスバー表示する。
def download_xbrl_from_sec_archive(index_url, title, save_dir = '.')
  doc = Hpricot( open(index_url).read )
  # files = doc.search('/html/body/table/tr/td/a')
  files = doc.search('/html/body/div/div/div/table/tr/td/a')
  pbar = ProgressBar.new(title, files.size)
  files.each do |a|
    data_url = a[:href]
    save_filepath = save_dir + data_url
    multi_mkdir(File.dirname(save_filepath))

    data = open(SEC_HOME + data_url).read
    File.open(save_filepath, "w") { |out|
      out.write data
    }
    pbar.inc
  end
  puts "\n"
end

# SEC のArcive ページを読んで、企業別データページの URL を取得する。
def read_archive_page
  list = {}

  doc = Hpricot( open(SEC_ARCHIVE_URL).read )
  trs = doc.search('/html/body/div/table[2]')

  name = ""
  url = ""
  (trs/:tr).each do |tr|
    corp = tr.inner_text
    name = corp.to_sym if /\(Filer\)/=~ corp
    (tr/:td/:a).each do |a|
      url= a[:href] if /\[html\]/=~ a.inner_text
      list[name] = SEC_HOME + url
    end
  end
  list
end

# See http://homepage1.nifty.com/~tetsu/ruby/cmd/mkdir.html
# 階層を含めて mkdir する
def multi_mkdir(mpath)
  path = ''
  mpath.split('/').each do |f|
    path.concat(f)
    Dir.mkdir(path) unless path == '' || File.exist?(path)
    path.concat('/')
  end
end

def usage
  puts "usage: ruby #{__FILE__} [n]"
  puts "     n: SEC の n 日以内の新しい XBRL ダータをダウンロードする。"
  puts "        指定省略した場合　７"
  puts "     データは ./Archies/edgar/... に保存される。"
end

# list = read_rss SEC_RSS
# list = read_archive_page
# download_xbrl_from_sec_archive SEC_HOME + "/Archives/edgar/data/896161/000110465908003603/0001104659-08-003603-index.htm"

range = 7  # デフォルト値 (7日以内のデータをダウンロードする

if ARGV.size > 1 || (ARGV.size >= 1 && (/^[0-9][0-9]*$/ =~ ARGV[0]) == nil)
  usage
  exit 1
end

range = ARGV.shift.to_i if ARGV.size > 0

list = read_rss SEC_RSS

count = 0
list.each do |corp, val|
  count += 1 if val[:date] >= Time.new - range * (24 * 60 * 60)
end
puts "downlaod #{count} corp(s)"

list.each do |corp, val|
  download_xbrl_from_sec_archive(val[:link], corp)  if val[:date] >= Time.new - range * (24 * 60 * 60)
end

#--- End of File ---
